% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-methods.R
\docType{methods}
\name{size}
\alias{size}
\alias{size,CohortSizeConst,ANY,Data-method}
\alias{size,CohortSizeDLT,ANY,Data-method}
\alias{size,CohortSizeMax,ANY,Data-method}
\alias{size,CohortSizeMin,ANY,Data-method}
\alias{size,CohortSizeParts,ANY,DataParts-method}
\alias{size,CohortSizeRange,ANY,Data-method}
\title{Determine the size of the next cohort}
\usage{
size(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeRange,ANY,Data}(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeDLT,ANY,Data}(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeMax,ANY,Data}(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeMin,ANY,Data}(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeConst,ANY,Data}(cohortSize, dose, data, ...)

\S4method{size}{CohortSizeParts,ANY,DataParts}(cohortSize, dose, data, ...)
}
\arguments{
\item{cohortSize}{The rule, an object of class
\code{\linkS4class{CohortSize}}}

\item{dose}{the next dose}

\item{data}{The data input, an object of class \code{\linkS4class{Data}}}

\item{\dots}{additional arguments}
}
\value{
the size as integer value
}
\description{
This function determines the size of the next cohort.
}
\section{Methods (by class)}{
\itemize{
\item \code{cohortSize = CohortSizeRange,dose = ANY,data = Data}: Determine the cohort size based on the range into which the
next dose falls into

\item \code{cohortSize = CohortSizeDLT,dose = ANY,data = Data}: Determine the cohort size based on the number of DLTs so
far

\item \code{cohortSize = CohortSizeMax,dose = ANY,data = Data}: Size based on maximum of multiple cohort size rules

\item \code{cohortSize = CohortSizeMin,dose = ANY,data = Data}: Size based on minimum of multiple cohort size rules

\item \code{cohortSize = CohortSizeConst,dose = ANY,data = Data}: Constant cohort size

\item \code{cohortSize = CohortSizeParts,dose = ANY,data = DataParts}: Cohort size based on the parts
}}
\examples{

# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Rule for the cohort size: 
#   - having cohort of size 1 for doses <30
#   - and having cohort of size 3 for doses >=30
mySize <- CohortSizeRange(intervals=c(0, 10),
                          cohortSize=c(1, 3))

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)


# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Rule for the cohort size: 
#   - having cohort of size 1 if no DLTs were yet observed
#   - and having cohort of size 3 if at least 1 DLT was already observed
mySize <- CohortSizeDLT(DLTintervals = c(0, 1),
                        cohortSize = c(1, 3))

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)


# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Rule for having cohort of size 1 for doses <30
#      and having cohort of size 3 for doses >=30
mySize1 <- CohortSizeRange(intervals = c(0, 10),
                           cohortSize = c(1, 3))

# Rule for having cohort of size 1 until no DLT were observed
#      and having cohort of size 3 as soon as 1 DLT is observed
mySize2 <- CohortSizeDLT(DLTintervals=c(0, 1),
                         cohortSize=c(1, 3))

# Combining the two rules for cohort size by taking the maximum of the sample sizes
# of the single rules
mySize <- maxSize(mySize1, mySize2)

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)




# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Rule for having cohort of size 1 for doses <30
#      and having cohort of size 3 for doses >=30
mySize1 <- CohortSizeRange(intervals = c(0, 30),
                           cohortSize = c(1, 3))

# Rule for having cohort of size 1 until no DLT were observed
#      and having cohort of size 3 as soon as 1 DLT is observed
mySize2 <- CohortSizeDLT(DLTintervals=c(0, 1),
                         cohortSize=c(1, 3))

# Combining the two rules for cohort size by taking the minimum of the sample sizes
# of the single rules
mySize <- minSize(mySize1, mySize2)

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)




# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Rule for having cohorts with constant cohort size of 3
mySize <- CohortSizeConst(size=3)

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)




# create an object of class 'DataParts'
data <- DataParts(x=c(0.1,0.5,1.5),
                  y=c(0,0,0),
                  doseGrid=c(0.1,0.5,1.5,3,6,
                             seq(from=10,to=80,by=2)),
                  part=c(1L,1L,1L),
                  nextPart=1L,
                  part1Ladder=c(0.1,0.5,1.5,3,6,10))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

myIncrements <- IncrementsRelativeParts(dltStart=0,
                                        cleanStart=1)
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, 
                               model=model, 
                               data=data)

# Rule for the cohort size: 
mySize <- CohortSizeParts(sizes=c(1,3))

# Determine the cohort size for the next cohort
size(mySize, dose=doseRecommendation$value, data = data)

}
\keyword{methods}

