% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataMixture-class}
\alias{.DataMixture}
\alias{DataMixture-class}
\title{Class for the data with mixture sharing}
\description{
Class for the data with mixture sharing
}
\section{Slots}{

\describe{
\item{\code{xshare}}{the doses for the share patients}

\item{\code{yshare}}{the vector of toxicity events (0 or 1 integers) for the share
patients}

\item{\code{nObsshare}}{number of share patients}
}}
\examples{
## decide on the dose grid:
doseGrid <- 1:80

## and MCMC options:
options <- McmcOptions()

## the classic model would be:
model <- LogisticLogNormal(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 50)

nodata <- Data(doseGrid=doseGrid)

priorSamples <- mcmc(nodata, model, options)
plot(priorSamples, model, nodata)

## set up the mixture model and data share object:
modelShare <- LogisticLogNormalMixture(shareWeight=0.1,
                                       mean = c(-0.85, 1),
                                       cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                                       refDose = 50)

nodataShare <- DataMixture(doseGrid=doseGrid,
                           xshare=
                             c(rep(10, 4),
                               rep(20, 4),
                               rep(40, 4)),
                           yshare=
                             c(rep(0L, 4),
                               rep(0L, 4),
                               rep(0L, 4)))

## now compare with the resulting prior model:
priorSamplesShare <- mcmc(nodataShare, modelShare, options)
plot(priorSamplesShare, modelShare, nodataShare)
}
\seealso{
\code{\linkS4class{LogisticLogNormalMixture}} for the explanation
how to use this data class
}
\keyword{classes}

