% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointEmax-class}
\alias{.DualEndpointEmax}
\alias{DualEndpointEmax-class}
\title{Dual endpoint model with emax function for dose-biomarker relationship}
\description{
This class extends the \code{\linkS4class{DualEndpoint}} class. Here the
dose-biomarker relationship \eqn{f(x)} is modelled by a parametric EMAX function:
}
\details{
\deqn{f(x) = E_{0} + \frac{(E_{max} - E_{0}) * (x/x^{*})}{ED_{50} + (x/x^{*})}}

where \eqn{x^{*}} is a reference dose, \eqn{E_{0}} and \eqn{E_{max}} are the
minimum and maximum levels for the biomarker and \eqn{ED_{50}} is the dose
achieving half of the maximum effect \eqn{0.5 * E_{max}}.

All parameters can currently be assigned uniform distributions or be fixed
in advance.
}
\section{Slots}{

\describe{
\item{\code{E0}}{either a fixed number or the two uniform distribution parameters}

\item{\code{Emax}}{either a fixed number or the two uniform distribution parameters}

\item{\code{ED50}}{either a fixed number or the two uniform distribution parameters}

\item{\code{refDose}}{the reference dose \eqn{x^{*}}}
}}
\examples{

model <- DualEndpointEmax(E0 = c(0, 100),
                          Emax = c(0, 500),
                          ED50 = c(10,200),
                          refDose = 1000,
                          mu = c(0, 1),
                          Sigma = matrix(c(1, 0, 0, 1), nrow=2),
                          sigma2W = c(a=0.1, b=0.1),
                          rho = c(a=1, b=1))


}
\keyword{classes}

