% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-methods.R
\name{minSize}
\alias{minSize}
\alias{minSize,CohortSize-method}
\title{"MIN" combination of cohort size rules}
\usage{
minSize(...)

\S4method{minSize}{CohortSize}(...)
}
\arguments{
\item{\dots}{Objects of class \code{\linkS4class{CohortSize}}}
}
\value{
the combination as an object of class
\code{\linkS4class{CohortSizeMin}}
}
\description{
This function combines cohort size rules by taking
the minimum of all sizes.
}
\section{Functions}{
\itemize{
\item \code{minSize(CohortSize)}: The method combining cohort size rules by taking minimum

}}
\examples{

# Here is the rule for: 
#   having cohort of size 1 for doses <30
#   and having cohort of size 3 for doses >=30
mySize1 <- CohortSizeRange(intervals = c(0, 30),
                           cohortSize = c(1, 3))

# Here is the rule for: 
#   having cohort of size 1 until no DLT were observed
#   and having cohort of size 3 as soon as 1 DLT is observed
mySize2 <- CohortSizeDLT(DLTintervals=c(0, 1),
                         cohortSize=c(1, 3))

# This is combining the two rules above by taking the minimum of the sample sizes of
# the single rules
mySize <- minSize(mySize1, mySize2)

}
\seealso{
\code{\link{maxSize}}
}
\keyword{methods}
