% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsMaxToxProb-class}
\alias{IncrementsMaxToxProb-class}
\alias{.IncrementsMaxToxProb}
\alias{IncrementsMaxToxProb}
\alias{.DefaultIncrementsMaxToxProb}
\title{\code{IncrementsMaxToxProb}}
\usage{
IncrementsMaxToxProb(prob)

.DefaultIncrementsMaxToxProb()
}
\arguments{
\item{prob}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{IncrementsMaxToxProb}} is the class for increments control based on
probability of toxicity
}
\section{Slots}{

\describe{
\item{\code{prob}}{(\code{numeric})\cr See Usage Notes below.}
}}

\note{
Typically, end users will not use the \code{.DefaultIncrementsMaxToxProb()} function.
}
\section{Usage Notes}{

For binary models, \code{prob} should be a scalar probability.

For ordinal models, \code{prob} should be a named vector containing the maximum
permissible probability of toxicity by grade.  The names should match the
names of the \code{yCategories} slot of the associated \code{DataOrdinal} object.
}

\examples{
# For use with binary models and data
IncrementsMaxToxProb(prob = 0.35)

# For use with ordinal models and data
IncrementsMaxToxProb(prob = c("DLAE" = 0.2, "DLT" = 0.05))
}
