% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{crm_cache}
\alias{crm_cache}
\title{Caching}
\description{
Manage cached \code{crminer} files with \pkg{hoardr}
}
\details{
The dafault cache directory is
\code{paste0(rappdirs::user_cache_dir(), "/R/crminer")}, but you can set
your own path using \code{cache_path_set()}

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}
\section{Useful user functions}{

\itemize{
\item \code{crm_cache$cache_path_get()} get cache path
\item \code{crm_cache$cache_path_set()} set cache path. You can set the
entire path directly via the \code{full_path} arg like
\code{crm_cache$cache_path_set(full_path = "your/path")}
\item \code{crm_cache$list()} returns a character vector of full
path file names
\item \code{crm_cache$files()} returns file objects with metadata
\item \code{crm_cache$details()} returns files with details
\item \code{crm_cache$delete()} delete specific files
\item \code{crm_cache$delete_all()} delete all files, returns nothing
}
}

\examples{
\dontrun{
crm_cache

# list files in cache
crm_cache$list()

# delete certain database files
# crm_cache$delete("file path")
# crm_cache$list()

# delete all files in cache
# crm_cache$delete_all()
# crm_cache$list()
}
}
