% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm_extract.R
\name{crm_extract}
\alias{crm_extract}
\title{Extract text from a single pdf document}
\usage{
crm_extract(path = NULL, raw = NULL, try_ocr = FALSE, ...)
}
\arguments{
\item{path}{(character) path to a file, file must exist}

\item{raw}{(raw) raw bytes}

\item{try_ocr}{(logical) whether to try extracting OCRed
pages with \code{pdftools::pdf_ocr_text()}. default: \code{FALSE}.
if \code{FALSE}, we use \code{pdftools::pdf_text()}}

\item{...}{args passed on to \code{pdftools::pdf_info()}
and \code{pdftools::pdf_text()} (or \code{pdftools::pdf_ocr_text()} if
\code{try_ocr=TRUE}) - any args are passed to
both of those function calls, which makes sense}
}
\value{
An object of class \code{crm_pdf} with a slot for
\code{info} (pdf metadata essentially), and \code{text} (the extracted
text) - with an attribute (\code{path}) with the path to the pdf
on disk
}
\description{
Extract text from a single pdf document
}
\details{
We use \pkg{pdftools} under the hood to do pdf text
extraction.

You have to supply either \code{path} or \code{raw} - not both.
}
\examples{
path <- system.file("examples", "MairChamberlain2014RJournal.pdf",
   package = "crminer")
(res <- crm_extract(path))
res$info
res$text
# with newlines, pretty print
cat(res$text)

# another example
path <- system.file("examples", "ChamberlainEtal2013Ecosphere.pdf",
   package = "crminer")
(res <- crm_extract(path))
res$info
cat(res$text)

# with raw pdf bytes
path <- system.file("examples", "raw-example.rds", package = "crminer")
rds <- readRDS(path)
class(rds)
crm_extract(raw = rds)
}
