% Generated by roxygen2 (4.0.2): do not edit by hand
\name{standardsFit}
\alias{standardsFit}
\title{Standards model}
\usage{
standardsFit(object, factors, ncomp = NULL, lg = TRUE, fitfunc = lm, ...)
}
\arguments{
\item{object}{an \code{ExpressionSet} or a \code{matrix}.   Note
that if you pass a\code{matrix} have to specify the identity of
the standards by   passing the appropriate argument to
\code{standards}.}

\item{factors}{the biological factors described in the pheno data
slot if \code{object} is an \code{ExpressionSet} or a design
matrix if \code{object} is a \code{matrix}.}

\item{ncomp}{number of PCA components to use.   Determined by
cross-validation if left \code{NULL}}

\item{lg}{logical indicating that the data should be log
transformed}

\item{fitfunc}{the function that creates the model fit for
normalization, must use the same interfaces as \code{lm}.}

\item{...}{passed on to \code{Q2}, \code{pca} (if pcaMethods >
1.26.0), \code{standards} and \code{analytes}}
}
\value{
a list containing the PCA/MLR model, the recommended number of
components for that model, the standard deviations and mean values
and Q2/R2 for the fit.
}
\description{
Fit a model which describes the variation of the labeled internal
standards from the biological factors.
}
\details{
There is often unwanted variation in among the labeled internal
standards which is related to the experimental factors due to
overlapping peaks etc. This function fits a model that describes
that overlapping variation using a scaled and centered PCA /
multiple linear regression model. Scaling is done outside the PCA
model.
}
\examples{
data(mix)
sfit <- standardsFit(mix, "type", ncomp=3)
slplot(sfit$fit$pc)
## same thing
Y <- exprs(mix)
G <- model.matrix(~-1+mix$type)
isIS <- fData(mix)$tag == 'IS'
sfit <- standardsFit(Y, G, standards=isIS, ncomp=3)
}
\author{
Henning Redestig
}
\seealso{
\code{makeX}, \code{standardsPred}
}

