% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crochet.R
\name{replace}
\alias{replace}
\title{Create an Implementation of [<- For Custom Matrix-Like Types}
\usage{
replace(replace_vector, replace_matrix)
}
\arguments{
\item{replace_vector}{A function in the form of \code{function(x, i, ..., value)}
that replaces a vector subset of \code{x} based on a single index \code{i} with the
values in \code{value} and returns \code{x}.}

\item{replace_matrix}{A function in the form of \code{function(x, i, j, ..., value)} that replaces a matrix subset of \code{x} based on two indices \code{i} and
\code{j} with the values in \code{value} and returns \code{x}.}
}
\value{
A function in the form of \code{function(x, i, j, ..., value)} that is
meant to be used as a method for \code{\link[base]{[<-}} for a custom type.
}
\description{
\code{replace} is a function that converts different index types such as negative
integer vectors, character vectors, or logical vectors passed to the \code{[<-}
function as \code{i} (e.g. \code{X[i]}) or \code{i} and \code{j} (e.g. \code{X[i, j]}) into positive
integer vectors. The converted indices are provided as the \code{i} parameter of
\code{replace_vector} or \code{i} and \code{j} parameters of \code{replace_matrix} to facilitate
implementing the replacement mechanism for custom matrix-like types. Values
are recycled to match the replacement length.

[<-\code{function as}i\code{(e.g.}X[i]: R:%3C-%60%0Afunction%20as%20%60i%60%20(e.g.%20%60X[i
[i, j]: R:i,%20j
}
\details{
The custom type must implement methods for \code{\link[base:dim]{base::dim()}} and
\code{\link[base:dimnames]{base::dimnames()}} for this function to work. Implementing methods for
\code{\link[base:nrow]{base::nrow()}}, \code{\link[base:ncol]{base::ncol()}}, \code{\link[base:rownames]{base::rownames()}}, and \code{\link[base:colnames]{base::colnames()}}
is not necessary as the default method of those generics calls \code{\link[base:dim]{base::dim()}}
or \code{\link[base:dimnames]{base::dimnames()}} internally.
}
\examples{
b <- matrix(data = rnorm(25), nrow = 5, ncol = 5)
dimnames(b) <- list(letters[1:5], letters[1:5])

a <- structure(list(), class = "TestMatrix")

dim.TestMatrix <- function(x) {
    dim(b)
}

dimnames.TestMatrix <- function(x) {
    dimnames(b)
}

extract_vector <- function(x, i) {
    # Dispatch to b instead to x for this demo
    b[i, drop = FALSE]
}

extract_matrix <- function(x, i, j) {
    # Dispatch to b instead to x for this demo
    b[i, j, drop = FALSE]
}

`[.TestMatrix` <- extract(extract_vector = extract_vector, extract_matrix = extract_matrix)

replace_vector <- function(x, i, value) {
    .GlobalEnv$i <- i
    .GlobalEnv$value <- value
    # Dispatch to b instead to x for this demo
    with(.GlobalEnv, b[i] <- value)
    # Don't forget to return x
    return(x)
}

replace_matrix <- function(x, i, j, value) {
    .GlobalEnv$i <- i
    .GlobalEnv$j <- j
    .GlobalEnv$value <- value
    # Dispatch to b instead to x for this demo
    with(.GlobalEnv, b[i, j] <- value)
    # Don't forget to return x
    return(x)
}

`[<-.TestMatrix` <- replace(replace_vector = replace_vector, replace_matrix = replace_matrix)
}
