% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmap_mat.R
\name{xmap_mat}
\alias{xmap_mat}
\alias{xmap_arr}
\title{Return a table applying a function to all combinations of list elements}
\usage{
xmap_mat(.l, .f, ..., .names = TRUE)

xmap_arr(.l, .f, ..., .names = TRUE)
}
\arguments{
\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.names}{A logical indicating whether to give names to the dimensions of
the matrix or array.
If inputs are named, the names are used.
If inputs are unnamed, the elements of the input are used as names.
Defaults to \code{TRUE}.}
}
\value{
A matrix (for \code{xmap_mat()}) or array (for \code{xmap_arr()}) with
dimensions equal to the lengths of each input in \code{.l}.
}
\description{
Return a table applying a function to all combinations of list elements
}
\examples{
xmap_mat(list(1:3, 1:3),  ~ ..1 * ..2)

fruits <- c(a = "apple", b = "banana", c = "cantaloupe")
xmap_mat(list(1:3, fruits), paste)
xmap_mat(list(1:3, fruits), paste, .names = FALSE)

xmap_arr(list(1:3, 1:3, 1:3),  ~ ..1 * ..2 * ..3)
}
\seealso{
\code{\link[=future_xmap_mat]{future_xmap_mat()}} and \code{\link[=future_xmap_arr]{future_xmap_arr()}} to run functions in
parallel.

\code{\link[=xmap_vec]{xmap_vec()}} to return a vector.

\code{\link[=xmap]{xmap()}} for the underlying functions.
}
