% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_normal}
\alias{body_add_normal}
\alias{body_add_glued}
\title{Add a new paragraph with default style}
\usage{
body_add_normal(doc, ..., .sep = "", squish = TRUE)
}
\arguments{
\item{doc}{the doc object (created with the \code{read_docx} function of \code{officer} package)}

\item{...}{one or several character strings, pasted using \code{.sep}. As with \code{glue::glue()}, expressions enclosed by braces will be evaluated as R code. If more than one variable is passed, all should be of length 1.}

\item{.sep}{Separator used to separate elements.}

\item{squish}{Whether to squish the result (remove trailing and repeated spaces). Default to \code{TRUE}.}
}
\value{
a new doc object

The docx object \code{doc}
}
\description{
Add a new paragraph in an \code{officer} document with default style. Variables can be inserted as multiple strings (\code{paste()} style) or enclosed by braces (\code{glue()} style).
References to any bookmark can be inserted using the syntax "\\@ref(bookmark)". See an example in \code{\link[=body_add_table_legend]{body_add_table_legend()}}.
}
\examples{
library(officer)
library(crosstable)

info_rows = c("Also, table iris has {nrow(iris)} rows.", 
              "And table mtcars has {nrow(mtcars)} rows.")
doc = read_docx()  \%>\% 
    body_add_normal("Table iris has", ncol(iris), "columns.", .sep=" ") \%>\% #paste style
    body_add_normal("However, table mtcars has {ncol(mtcars)} columns") \%>\% #glue style
    body_add_normal(info_rows)                                              #vector style
#write_and_open(doc)
}
\author{
Dan Chaltiel

Dan Chaltiel
}
