% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{summaryFunctions}
\alias{summaryFunctions}
\alias{meansd}
\alias{moystd}
\alias{meanCI}
\alias{mediqr}
\alias{minmax}
\alias{nna}
\title{Summary functions}
\usage{
meansd(x, na.rm = TRUE, dig = 2, ...)

meanCI(x, na.rm = TRUE, dig = 2, level = 0.95, format = TRUE, ...)

mediqr(x, na.rm = TRUE, dig = 2, format = TRUE, ...)

minmax(x, na.rm = TRUE, dig = 2, ...)

nna(x)
}
\arguments{
\item{x}{a numeric vector}

\item{na.rm}{\code{TRUE} as default}

\item{dig}{number of digits}

\item{...}{params to pass on to \code{\link[=format_fixed]{format_fixed()}}:
\itemize{
\item \code{zero_digits} (default=\code{1}): the number of significant digits for values rounded to 0 (set to NULL to keep the original 0 value)
\item \code{only_round} (default=\code{FALSE}): use \code{\link[=round]{round()}} instead of \code{\link[=format_fixed]{format_fixed()}}
}}

\item{level}{the confidence level required}

\item{format}{a sugar argument. If FALSE, the function returns a list instead of a formatted string}
}
\value{
a character vector
}
\description{
Summary functions to use with \code{\link[=crosstable]{crosstable()}} or anywhere else.
}
\section{Functions}{
\itemize{
\item \code{meansd}: returns mean and std error

\item \code{meanCI}: returns mean and confidence interval

\item \code{mediqr}: returns median and IQR

\item \code{minmax}: returns minimum and maximum

\item \code{nna}: returns  number of observations and number of missing values
}}

\section{Fixed format}{

These functions use \code{\link[=format_fixed]{format_fixed()}} which allows to have trailing zeros after rounded values.
In the case when the output of rounded values is zero, the use of the \code{zero_digits} argument allows to keep some significant digits for this specific case only.
}

\examples{
meansd(iris$Sepal.Length, dig=3)
meanCI(iris$Sepal.Length)
minmax(iris$Sepal.Length, dig=3)
mediqr(iris$Sepal.Length, dig=3)
nna(iris$Sepal.Length)

#arguments for format_fixed
x = iris$Sepal.Length/10000 #closer to zero 

meansd(x, dig=3)
meansd(x, dig=3, zero_digits=NULL) #or NA
meansd(x, dig=3, only_round=TRUE)
options("crosstable_only_round"=TRUE)
meansd(x, dig=3, zero_digits=2)
options("crosstable_only_round"=NULL)
meanCI(mtcars2$x_date)

#dates
x = as.POSIXct(mtcars$qsec*3600*24 , origin="2010-01-01")
meansd(x)
minmax(x, date_format="\%d/\%m/\%Y")

}
\seealso{
\code{\link[=format_fixed]{format_fixed()}}
}
\author{
Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage
}
