% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_crosstalk.R
\name{compute_crosstalk}
\alias{compute_crosstalk}
\title{Identify proteins with a statistically significant relationship to user-provided seeds.}
\usage{
compute_crosstalk(
  seed_proteins,
  g = NULL,
  use_ppi = TRUE,
  ppi = "stringdb",
  species = "homo sapiens",
  n = 1000,
  union = FALSE,
  intersection = FALSE,
  gamma = 0.6,
  eps = 1e-10,
  tmax = 1000,
  norm = TRUE,
  set_seed,
  cache = NULL,
  min_score = 700,
  seed_name = NULL,
  ncores = 1,
  significance_level = 0.95,
  p_adjust = "bonferroni",
  agg_int = 100
)
}
\arguments{
\item{seed_proteins}{user defined seed proteins}

\item{g}{igraph network object.}

\item{use_ppi}{bool, should g be a protein-protein interaction network? If
false, user must provide an igraph object in \code{g}}

\item{ppi}{character string describing the ppi to use: currently only "stringdb" and "biogrid" are supported.}

\item{species}{character string describing the species of interest.
For a list of supported species, see \code{supported_species}.
Non human species are only compatible with "stringdb"}

\item{n}{number of random walks with repeats to create null distribution}

\item{union}{bool, should we take the union of string db and biogrid to compute the PPI? Only applicable for the human PPI}

\item{intersection}{bool, should we take the intersection of string db and biogrid to compute the PPI? Only applicable for the human PPI}

\item{gamma}{restart probability}

\item{eps}{maximum allowed difference between the computed probabilities at the steady state}

\item{tmax}{the maximum number of iterations for the RWR}

\item{norm}{if True, w is normalized by dividing each value by the column sum.}

\item{set_seed}{integer to set random number seed - for reproducibility}

\item{cache}{A filepath to a folder downloaded files should be stored}

\item{min_score}{minimum connectivity score for each edge in the network.}

\item{seed_name}{Name to give the cached ngull distribution - must be a character string}

\item{ncores}{Number of cores to use - defaults to 1. Significant speedup can be achieved by using multiple cores for computation.}

\item{significance_level}{user-defined signficance level for hypothesis testing}

\item{p_adjust}{adjustment method to correct for multiple hypothesis testing:
defaults to "holm". see \code{p.adjust.methods} for other potential
adjustment methods.}

\item{agg_int}{number of runs before we need to aggregate the results - necessary to save memory. set at lower numbers to save even more memory.}
}
\value{
data frame containing affinity score, p-value, for all "crosstalkers"
related to a given set of seeds
}
\description{
\code{compute_crosstalk} returns a dataframe of proteins that are significantly
associated with user-defined seed proteins. These identified "crosstalkers"
can be combined with the user-defined seed proteins to identify functionally
relevant subnetworks. Affinity scores for every protein in the network are
calculated using a random-walk with repeats (\code{sparseRWR}). Significance is
determined by comparing these affinity scores to a bootstrapped null distribution
(see \code{bootstrap_null}). If using non-human PPI from string, refer to the stringdb documentation
for how to specify proteins
}
\examples{
\donttest{
#1) easy to use for querying biological networks - n = 10000 is more appropriate for actual analyses
#compute_crosstalk(c("EGFR", "KRAS"), n =10)
}
#2) Also works for any other kind of graph- just specify g (must be igraph formatted as of now)
g <- igraph::sample_gnp(n = 1000, p = 10/1000)
compute_crosstalk(c(1,3,5,8,10), g = g, use_ppi = FALSE, n = 100)


}
