% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\docType{data}
\name{Async}
\alias{Async}
\title{Simple async client}
\arguments{
\item{urls}{(character) one or more URLs (required)}
}
\value{
a list, with objects of class \code{\link[=HttpResponse]{HttpResponse()}}
}
\description{
A client to work with many URLs, but all with the same HTTP method
}
\details{
\strong{Methods}
\describe{
\item{\code{get(path, query, ...)}}{
make async GET requests for all URLs
}
\item{\code{post(path, query, body, encode, ...)}}{
make async POST requests for all URLs
}
\item{\code{put(path, query, body, encode, ...)}}{
make async PUT requests for all URLs
}
\item{\code{patch(path, query, body, encode, ...)}}{
make async PATCH requests for all URLs
}
\item{\code{delete(path, query, body, encode, ...)}}{
make async DELETE requests for all URLs
}
\item{\code{head(path, ...)}}{
make async HEAD requests for all URLs
}
}

See \code{\link[=HttpClient]{HttpClient()}} for information on parameters.
}
\examples{
\dontrun{
cc <- Async$new(
  urls = c(
    'https://httpbin.org/',
    'https://httpbin.org/get?a=5',
    'https://httpbin.org/get?foo=bar'
  )
)
cc
(res <- cc$get())
res[[1]]
res[[1]]$url
res[[1]]$success()
res[[1]]$status_http()
res[[1]]$response_headers
res[[1]]$method
res[[1]]$content
res[[1]]$parse("UTF-8")

lapply(res, function(z) z$parse("UTF-8"))
}
}
\seealso{
Other async: \code{\link{AsyncVaried}}
}
\keyword{datasets}
