% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{HttpClient}
\alias{HttpClient}
\title{HTTP client}
\value{
an \link{HttpResponse} object
}
\description{
Create and execute HTTP requests
}
\note{
A little quirk about \code{crul} is that because user agent string can
be passed as either a header or a curl option (both lead to a \code{User-Agent}
header being passed in the HTTP request), we return the user agent
string in the \code{request_headers} list of the response even if you
pass in a \code{useragent} string as a curl option. Note that whether you pass
in as a header like \code{User-Agent} or as a curl option like \code{useragent},
it is returned as \code{request_headers$User-Agent} so at least accessing
it in the request headers is consistent.
}
\section{handles}{

curl handles are re-used on the level of the connection object, that is,
each \code{HttpClient} object is separate from one another so as to better
separate connections.

If you don't pass in a curl handle to the \code{handle} parameter,
it gets created when a HTTP verb is called. Thus, if you try to get \code{handle}
after creating a \code{HttpClient} object only passing \code{url} parameter, \code{handle}
will be \code{NULL}. If you pass a curl handle to the \code{handle} parameter, then
you can get the handle from the \code{HttpClient} object. The response from a
http verb request does have the handle in the \code{handle} slot.
}

\examples{
\dontrun{
# set your own handle
(h <- handle("https://httpbin.org"))
(x <- HttpClient$new(handle = h))
x$handle
x$url
(out <- x$get("get"))
x$handle
x$url
class(out)
out$handle
out$request_headers
out$response_headers
out$response_headers_all

# if you just pass a url, we create a handle for you
#  this is how most people will use HttpClient
(x <- HttpClient$new(url = "https://httpbin.org"))
x$url
x$handle # is empty, it gets created when a HTTP verb is called
(r1 <- x$get('get'))
x$url
x$handle
r1$url
r1$handle
r1$content
r1$response_headers
r1$parse()

(res_get2 <- x$get('get', query = list(hello = "world")))
res_get2$parse()
library("jsonlite")
jsonlite::fromJSON(res_get2$parse())

# post request
(res_post <- x$post('post', body = list(hello = "world")))

## empty body request
x$post('post')

# put request
(res_put <- x$put('put'))

# delete request
(res_delete <- x$delete('delete'))

# patch request
(res_patch <- x$patch('patch'))

# head request
(res_head <- x$head())

# query params are URL encoded for you, so DO NOT do it yourself
## if you url encode yourself, it gets double encoded, and that's bad
(x <- HttpClient$new(url = "https://httpbin.org"))
res <- x$get("get", query = list(a = 'hello world'))

# access intermediate headers in response_headers_all
x <- HttpClient$new("https://doi.org/10.1007/978-3-642-40455-9_52-1")
bb <- x$get()
bb$response_headers_all
}

## ------------------------------------------------
## Method `HttpClient$verb`
## ------------------------------------------------

\dontrun{
(x <- HttpClient$new(url = "https://httpbin.org"))
x$verb('get')
x$verb('GET')
x$verb('GET', query = list(foo = "bar"))
x$verb('retry', 'GET', path = "status/400")
}

## ------------------------------------------------
## Method `HttpClient$retry`
## ------------------------------------------------

\dontrun{
x <- HttpClient$new(url = "https://httpbin.org")

# retry, by default at most 3 times
(res_get <- x$retry("GET", path = "status/400"))

# retry, but not for 404 NOT FOUND
(res_get <- x$retry("GET", path = "status/404", terminate_on = c(404)))

# retry, but only for exceeding rate limit (note that e.g. Github uses 403)
(res_get <- x$retry("GET", path = "status/429", retry_only_on = c(403, 429)))
}

## ------------------------------------------------
## Method `HttpClient$url_fetch`
## ------------------------------------------------

x <- HttpClient$new(url = "https://httpbin.org")
x$url_fetch()
x$url_fetch('get')
x$url_fetch('post')
x$url_fetch('get', query = list(foo = "bar"))
}
\seealso{
\link{http-headers}, \link{writing-options}, \link{cookies}, \link{hooks}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{(character) a url}

\item{\code{opts}}{(list) named list of curl options}

\item{\code{proxies}}{a \code{\link[=proxy]{proxy()}} object}

\item{\code{auth}}{an \code{\link[=auth]{auth()}} object}

\item{\code{headers}}{(list) named list of headers, see \link{http-headers}}

\item{\code{handle}}{a \code{\link[=handle]{handle()}}}

\item{\code{progress}}{only supports \code{httr::progress()}, see \link{progress}}

\item{\code{hooks}}{a named list, see \link{hooks}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{HttpClient$print()}}
\item \href{#method-new}{\code{HttpClient$new()}}
\item \href{#method-get}{\code{HttpClient$get()}}
\item \href{#method-post}{\code{HttpClient$post()}}
\item \href{#method-put}{\code{HttpClient$put()}}
\item \href{#method-patch}{\code{HttpClient$patch()}}
\item \href{#method-delete}{\code{HttpClient$delete()}}
\item \href{#method-head}{\code{HttpClient$head()}}
\item \href{#method-verb}{\code{HttpClient$verb()}}
\item \href{#method-retry}{\code{HttpClient$retry()}}
\item \href{#method-handle_pop}{\code{HttpClient$handle_pop()}}
\item \href{#method-url_fetch}{\code{HttpClient$url_fetch()}}
\item \href{#method-clone}{\code{HttpClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{HttpClient} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new HttpClient object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$new(
  url,
  opts,
  proxies,
  auth,
  headers,
  handle,
  progress,
  hooks,
  verbose
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{(character) A url. One of \code{url} or \code{handle} required.}

\item{\code{opts}}{any curl options}

\item{\code{proxies}}{a \code{\link[=proxy]{proxy()}} object}

\item{\code{auth}}{an \code{\link[=auth]{auth()}} object}

\item{\code{headers}}{named list of headers, see \link{http-headers}}

\item{\code{handle}}{a \code{\link[=handle]{handle()}}}

\item{\code{progress}}{only supports \code{httr::progress()}, see \link{progress}}

\item{\code{hooks}}{a named list, see \link{hooks}}

\item{\code{verbose}}{a special handler for verbose curl output,
accepts a function only. default is \code{NULL}. if used, \code{verbose}
and \code{debugfunction} curl options are ignored if passed to \code{opts}
on \verb{$new()} and ignored if \code{...} passed to a http method call}

\item{\code{urls}}{(character) one or more URLs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{HttpClient} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Make a GET request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$get(path = NULL, query = list(), disk = NULL, stream = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-post"></a>}}
\if{latex}{\out{\hypertarget{method-post}{}}}
\subsection{Method \code{post()}}{
Make a POST request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$post(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
Make a PUT request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$put(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-patch"></a>}}
\if{latex}{\out{\hypertarget{method-patch}{}}}
\subsection{Method \code{patch()}}{
Make a PATCH request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$patch(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
Make a DELETE request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$delete(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-head"></a>}}
\if{latex}{\out{\hypertarget{method-head}{}}}
\subsection{Method \code{head()}}{
Make a HEAD request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$head(path = NULL, query = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-verb"></a>}}
\if{latex}{\out{\hypertarget{method-verb}{}}}
\subsection{Method \code{verb()}}{
Use an arbitrary HTTP verb supported on this class
Supported verbs: "get", "post", "put", "patch", "delete", "head". Also
supports retry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$verb(verb, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verb}}{an HTTP verb supported on this class: "get",
"post", "put", "patch", "delete", "head". Also supports retry.}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
(x <- HttpClient$new(url = "https://httpbin.org"))
x$verb('get')
x$verb('GET')
x$verb('GET', query = list(foo = "bar"))
x$verb('retry', 'GET', path = "status/400")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-retry"></a>}}
\if{latex}{\out{\hypertarget{method-retry}{}}}
\subsection{Method \code{retry()}}{
Retry a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$retry(
  verb,
  ...,
  pause_base = 1,
  pause_cap = 60,
  pause_min = 1,
  times = 3,
  terminate_on = NULL,
  retry_only_on = NULL,
  onwait = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verb}}{an HTTP verb supported on this class: "get",
"post", "put", "patch", "delete", "head". Also supports retry.}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}

\item{\code{pause_base, pause_cap, pause_min}}{basis, maximum, and minimum for
calculating wait time for retry. Wait time is calculated according to the
exponential backoff with full jitter algorithm. Specifically, wait time is
chosen randomly between \code{pause_min} and the lesser of \code{pause_base * 2} and
\code{pause_cap}, with \code{pause_base} doubling on each subsequent retry attempt.
Use \code{pause_cap = Inf} to not terminate retrying due to cap of wait time
reached.}

\item{\code{times}}{the maximum number of times to retry. Set to \code{Inf} to
not stop retrying due to exhausting the number of attempts.}

\item{\code{terminate_on, retry_only_on}}{a vector of HTTP status codes. For
\code{terminate_on}, the status codes for which to terminate retrying, and for
\code{retry_only_on}, the status codes for which to retry the request.}

\item{\code{onwait}}{a callback function if the request will be retried and
a wait time is being applied. The function will be passed two parameters,
the response object from the failed request, and the wait time in seconds.
Note that the time spent in the function effectively adds to the wait time,
so it should be kept simple.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Retries the request given by \code{verb} until successful
(HTTP response status < 400), or a condition for giving up is met.
Automatically recognizes \code{Retry-After} and \code{X-RateLimit-Reset} headers
in the response for rate-limited remote APIs.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
x <- HttpClient$new(url = "https://httpbin.org")

# retry, by default at most 3 times
(res_get <- x$retry("GET", path = "status/400"))

# retry, but not for 404 NOT FOUND
(res_get <- x$retry("GET", path = "status/404", terminate_on = c(404)))

# retry, but only for exceeding rate limit (note that e.g. Github uses 403)
(res_get <- x$retry("GET", path = "status/429", retry_only_on = c(403, 429)))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-handle_pop"></a>}}
\if{latex}{\out{\hypertarget{method-handle_pop}{}}}
\subsection{Method \code{handle_pop()}}{
reset your curl handle
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$handle_pop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-url_fetch"></a>}}
\if{latex}{\out{\hypertarget{method-url_fetch}{}}}
\subsection{Method \code{url_fetch()}}{
get the URL that would be sent (i.e., before executing
the request) the only things that change the URL are path and query
parameters; body and any curl options don't change the URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$url_fetch(path = NULL, query = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
URL (character)
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{x <- HttpClient$new(url = "https://httpbin.org")
x$url_fetch()
x$url_fetch('get')
x$url_fetch('post')
x$url_fetch('get', query = list(foo = "bar"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
