% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-subset.R
\name{translateCubeIndex}
\alias{translateCubeIndex}
\title{Translate user facing cube subset to programmatic cube subset}
\usage{
translateCubeIndex(x, subset, drop)
}
\arguments{
\item{x}{a Crunch Cube}

\item{subset}{a list of array extent indices (for the user-cube)}

\item{drop}{whether to drop unnecessary dimensions.}
}
\value{
a list of array extent indices (for the real-cube)
}
\description{
Cubes that include multiple response variables create a special kind of
complexity. Multiple response variables are actually 2d arrays with the
responses along one dimension (\code{cat}, \code{dog}, \code{fish}) and the selection
status along the second dimension (\code{selected}, \code{not_selected}). When an MR
variable is crossed with a categorical variable it creates a 3d array with
the categorical variable's categories along one dimension and the MR
dimensions on the other two.
}
\details{
The complexity is that while the real MR cube includes two dimensions per MR,
we only show the user one dimension per MR which represents only the
\code{selected} items. This means that every cube has two different
representations, the low dimensional user cube, and the higher dimensional
real cube. This function translates user cube subsets into the higher
dimensional subset. In the case above, the user would see a 2d cube and
subset it with \code{user_cube[1:2, 1:2]} in order to subset the programmatic cube
we need to translate this to \code{prog_cube[1:2, 1:2, ]} in order to select the
right variables of the high dimensional cube.
}
\keyword{internal}
