% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{calculate_cell_volume.unit_cell}
\alias{calculate_cell_volume.unit_cell}
\title{Volume of a unit cell (in angstroms^3)}
\usage{
\method{calculate_cell_volume}{unit_cell}(x, ...)
}
\arguments{
\item{x}{An object of class "unit_cell".}

\item{...}{Additional arguments passed to the calculate_cell_volume methods}
}
\value{
A positive numeric, the volume in cubic angstroms of the unit cell
 corresponding to the input.
}
\description{
Method of the S3 generic class "calculate_cell_volume", to calculate the
volume, in cubic angstroms, of the unit cell corresponding to the input
object of class "unit_cell".
}
\examples{
# Create a monoclinic cell
bt <- bravais("mP")
uc <- create_unit_cell(bt)
print(uc)

# Calculate cell volume
calculate_cell_volume(uc)

}
