% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{symm_to_cell_const}
\alias{symm_to_cell_const}
\title{Cell parameter constrains from symmetry}
\usage{
symm_to_cell_const(SG)
}
\arguments{
\item{SG}{A character string indicating the extended
Hermann-Mauguin symbol for the space group.}
}
\value{
vcons A character vector. Each component is a string,
              like 'alpha=90' or 'a=b', that describes the
              type of constrain to be applied to a unit cell
              of a crystal structure with given space group
              symmetry (see above).
}
\description{
This function returns a set of constrains, as string character
expressions, imposed by the specific symmetry group on the
given unit cell.
}
\details{
Space group symmetry imposes certain constraints on the
values that unit cell parameters can take. For example, the
symmetry represented by the monoclinic space group of extended
Hermann-Mauguin symbol "P 1 2 1" is compatible with a unit cell
in which alpha=gamma=90.

There is just a handful of constrains for unit cells. Here they
are indicated with the following set of specific strings:
\itemize{
  \item \strong{'No constrains'} Like in a triclinic cell.
  \item \strong{'alpha=90'} The alpha angle is fixed at 90
                          degrees.
  \item \strong{'beta=90'} The beta angle is fixed at 90
                         degrees.
  \item \strong{'gamma=90'} The gamma angle is fixed at 90
                            degrees.
  \item \strong{'gamma=120'} The gamma angle is fixed at 120
                             degrees.
  \item \strong{'alpha=beta=gamma'} The three angle have the
                                    same value, different
                                    from 90 degrees.
  \item \strong{'a=b'} Cell side a is equal to cell side b.
  \item \strong{'a=b=c'} The three cell sides are equal.
}
}
\examples{
# P 1 1 2 (group number 3) corresponds to setting 2
SG <- translate_SG(3,set=2)

# Constrains for this symmetry
stmp <- symm_to_cell_const(SG)
print(stmp)

# R 3 (rombohedral setting)
stmp <- symm_to_cell_const("R 3 :R")
print(stmp)

}
