% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_xts.R
\name{crypto_xts}
\alias{crypto_xts}
\title{crypto_xts}
\usage{
crypto_xts(df, frequency = NULL)
}
\arguments{
\item{df}{data.frame from \code{getCoins()}}

\item{frequency}{string \code{?round_date} for help}
}
\value{
xts
}
\description{
Converts the \code{getCoins()} dataframe into
 an xts object. Provide frequency to summarise into specific
 time periods.
}
\note{
Each value in \code{frequency <- c('second', 'minute',
'hour', 'day', 'week', 'month', 'year')} can have an integer
 in front of it to retrieve the expressed time period. i.e. 3month
}
\examples{
  \dontrun{
 You can lookup additional frequencies at \\code{?round_date}
 from the lubridate package.
    crypto_xts(df, '.5s')
    crypto_xts(df, 'sec')
    crypto_xts(df, 'second')
    crypto_xts(df, 'minute')
    crypto_xts(df, '5 mins')
    crypto_xts(df, 'hour')
    crypto_xts(df, '2 hours')
    crypto_xts(df, 'day')
    crypto_xts(df, 'week')
    crypto_xts(df, 'month')
    crypto_xts(df, 'bimonth')
    crypto_xts(df, '3 months')
    crypto_xts(df, 'halfyear')
    crypto_xts(df, 'year')
}
}
