% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableExchanges.R
\name{availableExchanges}
\alias{availableExchanges}
\title{Get available exchanges}
\usage{
availableExchanges(type = "ohlc")
}
\arguments{
\item{type}{\link{character}-vector of length 1. See details}
}
\value{
An \code{\link[=invisible]{invisible()}} \link{character} vector containing available exchanges
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Get a vector of all available exchanges passed into the source
argument of the get-functions.
}
\details{
\subsection{Available types}{
\itemize{
\item ohlc: Open, High, Low, Close and Volume
\item lsratio: Long-Short ratio
\item fundingrate: Funding rates
\item interest: Open perpetual contracts on both sides
}
}

\subsection{Limits}{

The endpoints supported by the \code{\link[=available_exchanges]{available_exchanges()}} are not uniform,
so exchanges available for, say, \code{\link[=get_lsratio]{get_lsratio()}} is not necessarily the same as those available for \code{\link[=get_quote]{get_quote()}}
}
}
\examples{
# script:
# date: 2023-10-06
# author: Serkan Korkmaz, serkor1@duck.com
# objective:
# script start;

## return all
## available exchanges
cryptoQuotes::available_exchanges()

# script end;
}
\seealso{
Other deprecated: 
\code{\link{availableIntervals}()},
\code{\link{availableTickers}()},
\code{\link{getFGIndex}()},
\code{\link{getLSRatio}()},
\code{\link{getQuote}()}
}
\author{
Serkan Korkmaz
}
\concept{deprecated}
