% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_openinterest.R
\name{get_openinterest}
\alias{get_openinterest}
\title{Get the open interest on perpetual futures contracts}
\usage{
## open interest
get_openinterest(
 ticker,
 interval = '1d',
 source   = 'binance',
 from     = NULL,
 to       = NULL
)
}
\arguments{
\item{ticker}{An \link{character}-vector of \link{length} 1. See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default. See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default. See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{from}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An \link{xts}-object containing,
\itemize{
\item open_interest (\link{numeric}): total open perpetual contracts on both both sides.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get the open interest on a cryptocurrency pair from the \code{\link[=available_exchanges]{available_exchanges()}} in any actively traded \code{\link[=available_tickers]{available_tickers()}} on the FUTURES markets.
}
\details{
\subsection{On time-zones and dates}{

Values passed to \code{from} or \code{to} must be coercible by \code{\link[=as.Date]{as.Date()}}, or \code{\link[=as.POSIXct]{as.POSIXct()}}, with a format of either \code{"\%Y-\%m-\%d"} or \code{"\%Y-\%m-\%d \%H:\%M:\%S"}. By default
all dates are passed and returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}. If only \code{to} is provided 200 pips up to the specified date
is returned.
}
}
\note{
Not all exchanges supports this endpoint, check \code{\link[=available_exchanges]{available_exchanges()}} for details.
}
\examples{
\dontrun{
  # script: Open Interest Example
  # date: 2024-03-03
  # author: Serkan Korkmaz, serkor1@duck.com
  # objective: Fetch
  # funding rate from one of the available
  # exchanges
  # script start;

  # 1) check available
  # exchanges for open interest
  available_exchanges(type = 'interest')

  # 2) get BTC funding rate
  # for the last 7 days
  tail(
    BTC <- get_openinterest(
      ticker = "BTCUSDT",
      source = "binance",
      from   = Sys.Date() - 7
    )
  )

  # script end;
}

}
\seealso{
Other get-function: 
\code{\link{get_fgindex}()},
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_quote}()}
}
\author{
Serkan Korkmaz
}
\concept{get-function}
