# shakepay

    Code
      formatted.shakepay
    Output
                       date currency    quantity total.price spot.rate transaction
      1 2021-05-07 14:50:41      BTC  0.00103982    53.03335  51002.43         buy
      2 2021-05-07 21:25:36      CAD 30.00000000     0.00000      1.00     revenue
      3 2021-05-08 12:12:57      BTC  0.00011000     0.00000  52582.03     revenue
      4 2021-05-09 12:22:07      BTC  0.00012000     0.00000  50287.01     revenue
      5 2021-05-21 12:47:14      BTC  0.00013000     0.00000  56527.62     revenue
      6 2021-06-11 12:03:31      BTC  0.00014000     0.00000  59978.05     revenue
      7 2021-06-23 12:21:49      BTC  0.00015000     0.00000  58099.18     revenue
      8 2021-07-10 00:52:19      BTC  0.00052991    31.26848  59007.15        sell
        fees   description  comment revenue.type     value exchange rate.source
      1    0 purchase/sale purchase         <NA> 53.033350 shakepay    exchange
      2    0         other   credit    referrals 30.000000 shakepay    exchange
      3    0   shakingsats   credit     airdrops  5.784024 shakepay    exchange
      4    0   shakingsats   credit     airdrops  6.034441 shakepay    exchange
      5    0   shakingsats   credit     airdrops  7.348590 shakepay    exchange
      6    0   shakingsats   credit     airdrops  8.396927 shakepay    exchange
      7    0   shakingsats   credit     airdrops  8.714877 shakepay    exchange
      8    0 purchase/sale     sale         <NA> 31.268480 shakepay    exchange
        currency2 total.quantity                                    suploss.range
      1       BTC     0.00103982 2021-04-07 14:50:41 UTC--2021-06-06 14:50:41 UTC
      2       CAD    30.00000000 2021-04-07 21:25:36 UTC--2021-06-06 21:25:36 UTC
      3       BTC     0.00114982 2021-04-08 12:12:57 UTC--2021-06-07 12:12:57 UTC
      4       BTC     0.00126982 2021-04-09 12:22:07 UTC--2021-06-08 12:22:07 UTC
      5       BTC     0.00139982 2021-04-21 12:47:14 UTC--2021-06-20 12:47:14 UTC
      6       BTC     0.00153982 2021-05-12 12:03:31 UTC--2021-07-11 12:03:31 UTC
      7       BTC     0.00168982 2021-05-24 12:21:49 UTC--2021-07-23 12:21:49 UTC
      8       BTC     0.00115991 2021-06-10 00:52:19 UTC--2021-08-09 00:52:19 UTC
        quantity.60days share.left60 sup.loss.quantity sup.loss gains.uncorrected
      1      0.00103982   0.00139982                 0    FALSE           0.00000
      2      0.00000000  30.00000000                 0    FALSE           0.00000
      3      0.00103982   0.00139982                 0    FALSE           0.00000
      4      0.00103982   0.00139982                 0    FALSE           0.00000
      5      0.00103982   0.00153982                 0    FALSE           0.00000
      6      0.00000000   0.00115991                 0    FALSE           0.00000
      7      0.00000000   0.00115991                 0    FALSE           0.00000
      8      0.00000000   0.00115991                 0    FALSE          14.63777
        gains.sup gains.excess    gains      ACB ACB.share
      1        NA           NA       NA 53.03335  51002.43
      2        NA           NA       NA  0.00000      0.00
      3        NA           NA       NA 53.03335  46123.18
      4        NA           NA       NA 53.03335  41764.46
      5        NA           NA       NA 53.03335  37885.84
      6        NA           NA       NA 53.03335  34441.27
      7        NA           NA       NA 53.03335  31384.02
      8        NA           NA 14.63777 36.40264  31384.02

# newton

    Code
      formatted.newton
    Output
                       date currency   quantity  total.price  spot.rate transaction
      1 2021-04-04 22:50:12      LTC  0.1048291   23.4912731   224.0911         buy
      2 2021-04-04 22:53:46      CAD 25.0000000    0.0000000     1.0000     revenue
      3 2021-04-04 22:55:55      ETH  2.7198712 3423.8221510  1258.8178         buy
      4 2021-04-21 19:57:26      BTC  0.0034300  153.1241354 44642.6051         buy
      5 2021-05-12 21:37:42      BTC  0.0000040    0.3049013 76225.3175         buy
      6 2021-05-12 21:52:40      BTC  0.0032130  156.1241341 48591.3894        sell
      7 2021-06-16 18:49:11      CAD 25.0000000    0.0000000     1.0000     revenue
        fees      description revenue.type        value exchange rate.source
      1    0            TRADE         <NA>   23.4912731   newton    exchange
      2    0 Referral Program    referrals   25.0000000   newton    exchange
      3    0            TRADE         <NA> 3423.8221510   newton    exchange
      4    0            TRADE         <NA>  153.1241354   newton    exchange
      5    0            TRADE         <NA>    0.3049013   newton    exchange
      6    0            TRADE         <NA>  156.1241341   newton    exchange
      7    0 Referral Program    referrals   25.0000000   newton    exchange
        currency2 total.quantity                                    suploss.range
      1       LTC      0.1048291 2021-03-05 22:50:12 UTC--2021-05-04 22:50:12 UTC
      2       CAD     25.0000000 2021-03-05 22:53:46 UTC--2021-05-04 22:53:46 UTC
      3       ETH      2.7198712 2021-03-05 22:55:55 UTC--2021-05-04 22:55:55 UTC
      4       BTC      0.0034300 2021-03-22 19:57:26 UTC--2021-05-21 19:57:26 UTC
      5       BTC      0.0034340 2021-04-12 21:37:42 UTC--2021-06-11 21:37:42 UTC
      6       BTC      0.0002210 2021-04-12 21:52:40 UTC--2021-06-11 21:52:40 UTC
      7       CAD     50.0000000 2021-05-17 18:49:11 UTC--2021-07-16 18:49:11 UTC
        quantity.60days share.left60 sup.loss.quantity sup.loss gains.uncorrected
      1       0.1048291    0.1048291          0.000000    FALSE           0.00000
      2       0.0000000   25.0000000          0.000000    FALSE           0.00000
      3       2.7198712    2.7198712          0.000000    FALSE           0.00000
      4       0.0034340    0.0002210          0.000000    FALSE           0.00000
      5       0.0034340    0.0002210          0.000000    FALSE           0.00000
      6       0.0034340    0.0002210          0.003213    FALSE          12.56924
      7       0.0000000   50.0000000          0.000000    FALSE           0.00000
        gains.sup gains.excess    gains         ACB  ACB.share
      1        NA           NA       NA   23.491273   224.0911
      2        NA           NA       NA    0.000000     0.0000
      3        NA           NA       NA 3423.822151  1258.8178
      4        NA           NA       NA  153.124135 44642.6051
      5        NA           NA       NA  153.429037 44679.3933
      6        NA           NA 12.56924    9.874146 44679.3933
      7        NA           NA       NA    0.000000     0.0000

# pooltool

    Code
      formatted.pooltool
    Output
                        date currency  quantity total.price spot.rate transaction
      1  2021-04-22 22:03:22      ADA 1.0827498    1.974017      1.82     revenue
      2  2021-04-27 22:22:14      ADA 0.8579850    1.565881      1.83     revenue
      3  2021-05-02 22:03:54      ADA 1.0193882    1.979399      1.94     revenue
      4  2021-05-07 22:54:38      ADA 1.0548971    1.790303      1.70     revenue
      5  2021-05-12 22:12:49      ADA 0.9443321    1.514525      1.60     revenue
      6  2021-05-17 22:47:25      ADA 1.0198183    1.426898      1.40     revenue
      7  2021-05-23 03:43:38      ADA 1.1605830    1.806024      1.56     revenue
      8  2021-05-27 22:07:57      ADA 1.0197753    1.589004      1.56     revenue
      9  2021-06-01 22:13:58      ADA 0.8392135    1.538300      1.83     revenue
      10 2021-06-06 22:14:11      ADA 1.1115378    2.072874      1.86     revenue
         fees description     comment revenue.type    value exchange rate.source
      1     0 epoch = 228 pool = REKT      staking 1.974017   exodus    pooltool
      2     0 epoch = 229 pool = REKT      staking 1.565881   exodus    pooltool
      3     0 epoch = 230 pool = REKT      staking 1.979399   exodus    pooltool
      4     0 epoch = 231 pool = REKT      staking 1.790303   exodus    pooltool
      5     0 epoch = 232 pool = REKT      staking 1.514525   exodus    pooltool
      6     0 epoch = 233 pool = REKT      staking 1.426898   exodus    pooltool
      7     0 epoch = 234 pool = REKT      staking 1.806024   exodus    pooltool
      8     0 epoch = 235 pool = REKT      staking 1.589004   exodus    pooltool
      9     0 epoch = 236 pool = REKT      staking 1.538300   exodus    pooltool
      10    0 epoch = 237 pool = REKT      staking 2.072874   exodus    pooltool
         currency2 total.quantity                                    suploss.range
      1        ADA       1.082750 2021-03-23 22:03:22 UTC--2021-05-22 22:03:22 UTC
      2        ADA       1.940735 2021-03-28 22:22:14 UTC--2021-05-27 22:22:14 UTC
      3        ADA       2.960123 2021-04-02 22:03:54 UTC--2021-06-01 22:03:54 UTC
      4        ADA       4.015020 2021-04-07 22:54:38 UTC--2021-06-06 22:54:38 UTC
      5        ADA       4.959352 2021-04-12 22:12:49 UTC--2021-06-11 22:12:49 UTC
      6        ADA       5.979170 2021-04-17 22:47:25 UTC--2021-06-16 22:47:25 UTC
      7        ADA       7.139753 2021-04-23 03:43:38 UTC--2021-06-22 03:43:38 UTC
      8        ADA       8.159529 2021-04-27 22:07:57 UTC--2021-06-26 22:07:57 UTC
      9        ADA       8.998742 2021-05-02 22:13:58 UTC--2021-07-01 22:13:58 UTC
      10       ADA      10.110280 2021-05-07 22:14:11 UTC--2021-07-06 22:14:11 UTC
         quantity.60days share.left60 sup.loss.quantity sup.loss gains.uncorrected
      1                0     5.979170                 0    FALSE                 0
      2                0     8.159529                 0    FALSE                 0
      3                0     8.159529                 0    FALSE                 0
      4                0    10.110280                 0    FALSE                 0
      5                0    10.110280                 0    FALSE                 0
      6                0    10.110280                 0    FALSE                 0
      7                0    10.110280                 0    FALSE                 0
      8                0    10.110280                 0    FALSE                 0
      9                0    10.110280                 0    FALSE                 0
      10               0    10.110280                 0    FALSE                 0
         gains.sup gains.excess gains       ACB ACB.share
      1         NA           NA    NA  1.974017  1.823152
      2         NA           NA    NA  3.539898  1.823999
      3         NA           NA    NA  5.519297  1.864550
      4         NA           NA    NA  7.309599  1.820564
      5         NA           NA    NA  8.824124  1.779290
      6         NA           NA    NA 10.251022  1.714456
      7         NA           NA    NA 12.057046  1.688720
      8         NA           NA    NA 13.646050  1.672407
      9         NA           NA    NA 15.184350  1.687386
      10        NA           NA    NA 17.257224  1.706899

# blockfi

    Code
      formatted.blockfi
    Output
                       date currency     quantity total.price    spot.rate
      1 2021-05-29 21:43:44      BTC  0.000018512   0.7858598 42451.369876
      2 2021-05-29 21:43:44      LTC  0.022451200   4.6255734   206.027889
      3 2021-06-13 21:43:44      BTC  0.000184120   0.0000000 45381.388034
      4 2021-06-30 21:43:44      BTC  0.000047234   2.0770535 43973.694092
      5 2021-06-30 21:43:44      LTC  0.010125120   1.8084980   178.614968
      6 2021-07-29 21:43:44     USDC  0.038241000   0.0477449     1.248526
      7 2021-08-07 21:43:44      BTC  0.000441230   0.0000000 54847.843168
      8 2021-10-24 04:29:23      LTC  0.165122140  68.0777573   412.287276
      9 2021-10-24 04:29:23     USDC 55.000000000  68.0777573     1.237777
        transaction fees      description revenue.type      value exchange
      1     revenue    0 Interest Payment    interests  0.7858598  blockfi
      2     revenue    0 Interest Payment    interests  4.6255734  blockfi
      3     revenue    0   Referral Bonus    referrals  8.3556212  blockfi
      4     revenue    0 Interest Payment    interests  2.0770535  blockfi
      5     revenue    0 Interest Payment    interests  1.8084980  blockfi
      6     revenue    0 Interest Payment    interests  0.0477449  blockfi
      7     revenue    0    Bonus Payment       promos 24.2005138  blockfi
      8        sell    0            Trade         <NA> 68.0777573  blockfi
      9         buy    0            Trade         <NA> 68.0777573  blockfi
                      rate.source currency2 total.quantity
      1             coinmarketcap       BTC    0.000018512
      2             coinmarketcap       LTC    0.022451200
      3             coinmarketcap       BTC    0.000202632
      4             coinmarketcap       BTC    0.000249866
      5             coinmarketcap       LTC    0.032576320
      6             coinmarketcap      USDC    0.038241000
      7             coinmarketcap       BTC    0.000691096
      8 coinmarketcap (buy price)       LTC   -0.132545820
      9             coinmarketcap      USDC   55.038241000
                                           suploss.range quantity.60days share.left60
      1 2021-04-29 21:43:44 UTC--2021-06-28 21:43:44 UTC               0  0.000202632
      2 2021-04-29 21:43:44 UTC--2021-06-28 21:43:44 UTC               0  0.022451200
      3 2021-05-14 21:43:44 UTC--2021-07-13 21:43:44 UTC               0  0.000249866
      4 2021-05-31 21:43:44 UTC--2021-07-30 21:43:44 UTC               0  0.000249866
      5 2021-05-31 21:43:44 UTC--2021-07-30 21:43:44 UTC               0  0.032576320
      6 2021-06-29 21:43:44 UTC--2021-08-28 21:43:44 UTC               0  0.038241000
      7 2021-07-08 21:43:44 UTC--2021-09-06 21:43:44 UTC               0  0.000691096
      8 2021-09-24 04:29:23 UTC--2021-11-23 04:29:23 UTC               0 -0.132545820
      9 2021-09-24 04:29:23 UTC--2021-11-23 04:29:23 UTC              55 55.038241000
        sup.loss.quantity sup.loss gains.uncorrected gains.sup gains.excess    gains
      1                 0    FALSE           0.00000        NA           NA       NA
      2                 0    FALSE           0.00000        NA           NA       NA
      3                 0    FALSE           0.00000        NA           NA       NA
      4                 0    FALSE           0.00000        NA           NA       NA
      5                 0    FALSE           0.00000        NA           NA       NA
      6                 0    FALSE           0.00000        NA           NA       NA
      7                 0    FALSE           0.00000        NA           NA       NA
      8                 0    FALSE          35.46488        NA           NA 35.46488
      9                 0    FALSE           0.00000        NA           NA       NA
                ACB    ACB.share
      1   0.7858598 42451.369876
      2   4.6255734   206.027889
      3   0.7858598  3878.260882
      4   2.8629132 11457.794281
      5   6.4340713   197.507617
      6   0.0477449     1.248526
      7   2.8629132  4142.569521
      8 -26.1788091     0.000000
      9  68.1255022     1.237785

# adalite

    Code
      formatted.adalite
    Output
                       date currency  quantity total.price spot.rate transaction fees
      1 2021-04-28 16:56:00      ADA 0.3120400   0.5091943  1.631824     revenue    0
      2 2021-05-07 16:53:00      ADA 0.3125132   0.6266931  2.005333     revenue    0
      3 2021-05-12 16:56:00      ADA 0.2212410   0.4441940  2.007738     revenue    0
      4 2021-05-17 17:16:00      ADA 0.4123210   1.0798503  2.618955     revenue    0
      5 2021-05-17 21:16:00      ADA 0.1691870   0.4430932  2.618955        sell    0
      6 2021-05-17 21:31:00      ADA 0.1912300   0.5008228  2.618955        sell    0
           description        comment revenue.type     value exchange   rate.source
      1 Reward awarded           <NA>      staking 0.5091943  adalite coinmarketcap
      2 Reward awarded           <NA>      staking 0.6266931  adalite coinmarketcap
      3 Reward awarded           <NA>      staking 0.4441940  adalite coinmarketcap
      4 Reward awarded           <NA>      staking 1.0798503  adalite coinmarketcap
      5           Sent Withdrawal Fee         <NA> 0.4430932  adalite coinmarketcap
      6           Sent Withdrawal Fee         <NA> 0.5008228  adalite coinmarketcap
        currency2 total.quantity                                    suploss.range
      1       ADA      0.3120400 2021-03-29 16:56:00 UTC--2021-05-28 16:56:00 UTC
      2       ADA      0.6245532 2021-04-07 16:53:00 UTC--2021-06-06 16:53:00 UTC
      3       ADA      0.8457942 2021-04-12 16:56:00 UTC--2021-06-11 16:56:00 UTC
      4       ADA      1.2581152 2021-04-17 17:16:00 UTC--2021-06-16 17:16:00 UTC
      5       ADA      1.0889282 2021-04-17 21:16:00 UTC--2021-06-16 21:16:00 UTC
      6       ADA      0.8976982 2021-04-17 21:31:00 UTC--2021-06-16 21:31:00 UTC
        quantity.60days share.left60 sup.loss.quantity sup.loss gains.uncorrected
      1               0    0.8976982                 0    FALSE        0.00000000
      2               0    0.8976982                 0    FALSE        0.00000000
      3               0    0.8976982                 0    FALSE        0.00000000
      4               0    0.8976982                 0    FALSE        0.00000000
      5               0    0.8976982                 0    FALSE        0.08539476
      6               0    0.8976982                 0    FALSE        0.09652065
        gains.sup gains.excess      gains       ACB ACB.share
      1        NA           NA         NA 0.5091943  1.631824
      2        NA           NA         NA 1.1358874  1.818720
      3        NA           NA         NA 1.5800813  1.868163
      4        NA           NA         NA 2.6599316  2.114219
      5        NA           NA 0.08539476 2.3022332  2.114219
      6        NA           NA 0.09652065 1.8979310  2.114219

# coinsmart

    Code
      formatted.coinsmart
    Output
                       date currency  quantity total.price    spot.rate transaction
      1 2021-04-25 16:11:24      ADA 198.50000 237.9374300     1.198677         buy
      2 2021-04-28 18:37:15      CAD  15.00000   0.0000000     1.000000     revenue
      3 2021-05-15 16:42:07      BTC   0.00004   0.0000000 58492.582640     revenue
      4 2021-06-03 02:04:49      ADA   0.30000   0.6512228     2.170743        sell
            fees description  comment revenue.type       value  exchange
      1 0.269386    purchase    Trade         <NA> 237.9374300 coinsmart
      2 0.000000       Other Referral    referrals  15.0000000 coinsmart
      3 0.000000       Other     Quiz     airdrops   2.3397033 coinsmart
      4 0.000000         Fee Withdraw         <NA>   0.6512228 coinsmart
          rate.source currency2 total.quantity
      1      exchange       ADA      198.50000
      2      exchange       CAD       15.00000
      3 coinmarketcap       BTC        0.00004
      4 coinmarketcap       ADA      198.20000
                                           suploss.range quantity.60days share.left60
      1 2021-03-26 16:11:24 UTC--2021-05-25 16:11:24 UTC           198.5    198.50000
      2 2021-03-29 18:37:15 UTC--2021-05-28 18:37:15 UTC             0.0     15.00000
      3 2021-04-15 16:42:07 UTC--2021-06-14 16:42:07 UTC             0.0      0.00004
      4 2021-05-04 02:04:49 UTC--2021-07-03 02:04:49 UTC             0.0    198.20000
        sup.loss.quantity sup.loss gains.uncorrected gains.sup gains.excess     gains
      1                 0    FALSE         0.0000000        NA           NA        NA
      2                 0    FALSE         0.0000000        NA           NA        NA
      3                 0    FALSE         0.0000000        NA           NA        NA
      4                 0    FALSE         0.2912125        NA           NA 0.2912125
             ACB ACB.share
      1 238.2068  1.200034
      2   0.0000  0.000000
      3   0.0000  0.000000
      4 237.8468  1.200034

# presearch

    Code
      formatted.presearch
    Output
                        date currency quantity total.price  spot.rate transaction
      1  2021-04-27 17:45:18      PRE     0.13     0.00000 0.09306492     revenue
      2  2021-04-27 17:48:00      PRE     0.13     0.00000 0.09306492     revenue
      3  2021-04-27 17:48:18      PRE     0.13     0.00000 0.09306492     revenue
      4  2021-04-27 17:55:24      PRE     0.13     0.00000 0.09306492     revenue
      5  2021-04-27 17:57:29      PRE     0.13     0.00000 0.09306492     revenue
      6  2021-04-27 19:00:31      PRE     0.13     0.00000 0.09306492     revenue
      7  2021-04-27 19:00:41      PRE     0.13     0.00000 0.09306492     revenue
      8  2021-04-27 19:01:57      PRE     0.13     0.00000 0.09306492     revenue
      9  2021-04-27 19:08:59      PRE     0.13     0.00000 0.09306492     revenue
      10 2021-04-27 19:12:15      PRE     0.13     0.00000 0.09306492     revenue
      11 2021-05-07 05:55:33      PRE  1000.00    78.90639 0.07890639         buy
         fees                                     description revenue.type
      1     0                                   Search Reward     airdrops
      2     0                                   Search Reward     airdrops
      3     0                                   Search Reward     airdrops
      4     0                                   Search Reward     airdrops
      5     0                                   Search Reward     airdrops
      6     0                                   Search Reward     airdrops
      7     0                                   Search Reward     airdrops
      8     0                                   Search Reward     airdrops
      9     0                                   Search Reward     airdrops
      10    0                                   Search Reward     airdrops
      11    0 Transferred from Presearch Portal (PO#: 412893)         <NA>
               value  exchange   rate.source currency2 total.quantity
      1   0.01209844 presearch coinmarketcap       PRE           0.13
      2   0.01209844 presearch coinmarketcap       PRE           0.26
      3   0.01209844 presearch coinmarketcap       PRE           0.39
      4   0.01209844 presearch coinmarketcap       PRE           0.52
      5   0.01209844 presearch coinmarketcap       PRE           0.65
      6   0.01209844 presearch coinmarketcap       PRE           0.78
      7   0.01209844 presearch coinmarketcap       PRE           0.91
      8   0.01209844 presearch coinmarketcap       PRE           1.04
      9   0.01209844 presearch coinmarketcap       PRE           1.17
      10  0.01209844 presearch coinmarketcap       PRE           1.30
      11 78.90639103 presearch coinmarketcap       PRE        1001.30
                                            suploss.range quantity.60days
      1  2021-03-28 17:45:18 UTC--2021-05-27 17:45:18 UTC            1000
      2  2021-03-28 17:48:00 UTC--2021-05-27 17:48:00 UTC            1000
      3  2021-03-28 17:48:18 UTC--2021-05-27 17:48:18 UTC            1000
      4  2021-03-28 17:55:24 UTC--2021-05-27 17:55:24 UTC            1000
      5  2021-03-28 17:57:29 UTC--2021-05-27 17:57:29 UTC            1000
      6  2021-03-28 19:00:31 UTC--2021-05-27 19:00:31 UTC            1000
      7  2021-03-28 19:00:41 UTC--2021-05-27 19:00:41 UTC            1000
      8  2021-03-28 19:01:57 UTC--2021-05-27 19:01:57 UTC            1000
      9  2021-03-28 19:08:59 UTC--2021-05-27 19:08:59 UTC            1000
      10 2021-03-28 19:12:15 UTC--2021-05-27 19:12:15 UTC            1000
      11 2021-04-07 05:55:33 UTC--2021-06-06 05:55:33 UTC            1000
         share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1        1001.3                 0    FALSE                 0        NA
      2        1001.3                 0    FALSE                 0        NA
      3        1001.3                 0    FALSE                 0        NA
      4        1001.3                 0    FALSE                 0        NA
      5        1001.3                 0    FALSE                 0        NA
      6        1001.3                 0    FALSE                 0        NA
      7        1001.3                 0    FALSE                 0        NA
      8        1001.3                 0    FALSE                 0        NA
      9        1001.3                 0    FALSE                 0        NA
      10       1001.3                 0    FALSE                 0        NA
      11       1001.3                 0    FALSE                 0        NA
         gains.excess gains      ACB  ACB.share
      1            NA    NA  0.00000 0.00000000
      2            NA    NA  0.00000 0.00000000
      3            NA    NA  0.00000 0.00000000
      4            NA    NA  0.00000 0.00000000
      5            NA    NA  0.00000 0.00000000
      6            NA    NA  0.00000 0.00000000
      7            NA    NA  0.00000 0.00000000
      8            NA    NA  0.00000 0.00000000
      9            NA    NA  0.00000 0.00000000
      10           NA    NA  0.00000 0.00000000
      11           NA    NA 78.90639 0.07880395

# CDC exchange rewards

    Code
      formatted.binance.rewards
    Output
                        date currency   quantity  total.price     spot.rate
      1  2021-02-19 00:00:00      CRO 1.36512341 0.2227899953     0.1632014
      2  2021-02-21 00:00:00      CRO 1.36945123 0.2411195812     0.1760702
      3  2021-04-15 16:04:21      BTC 0.00000023 0.0182149274 79195.3367033
      4  2021-04-18 00:00:00      CRO 1.36512310 0.3798900187     0.2782826
      5  2021-05-14 06:02:22      BTC 0.00000035 0.0211513332 60432.3807116
      6  2021-06-12 15:21:34      BTC 0.00000630 0.2791139040 44303.7942802
      7  2021-06-27 01:34:00      CRO 0.00100000 0.0001239785     0.1239785
      8  2021-07-07 00:00:00      CRO 0.01512903 0.0000000000     0.1511808
      9  2021-07-13 00:00:00      CRO 0.05351230 0.0000000000     0.1572142
      10 2021-09-07 00:00:00      CRO 0.01521310 0.0000000000     0.2341842
         transaction fees description
      1      revenue    0      Reward
      2      revenue    0      Reward
      3      revenue    0      Reward
      4      revenue    0      Reward
      5      revenue    0      Reward
      6      revenue    0      Reward
      7         sell    0  Withdrawal
      8      revenue    0      Reward
      9      revenue    0      Reward
      10     revenue    0      Reward
                                                  comment revenue.type        value
      1  Interest on 5000.00000000 at 10% APR (Completed)    interests 0.2227899953
      2  Interest on 5000.00000000 at 10% APR (Completed)    interests 0.2411195812
      3                           BTC Supercharger reward    interests 0.0182149274
      4  Interest on 5000.00000000 at 10% APR (Completed)    interests 0.3798900187
      5                           BTC Supercharger reward    interests 0.0211513332
      6                           BTC Supercharger reward    interests 0.2791139040
      7                                              <NA>         <NA> 0.0001239785
      8                   Rebate on 0.18512341 CRO at 10%      rebates 0.0022872188
      9                 Rebate on 0.5231512346 CRO at 10%      rebates 0.0084128916
      10                 Rebate on 0.155125123 CRO at 10%      rebates 0.0035626681
             exchange   rate.source currency2 total.quantity
      1  CDC.exchange coinmarketcap       CRO     1.36512341
      2  CDC.exchange coinmarketcap       CRO     2.73457464
      3  CDC.exchange coinmarketcap       BTC     0.00000023
      4  CDC.exchange coinmarketcap       CRO     4.09969774
      5  CDC.exchange coinmarketcap       BTC     0.00000058
      6  CDC.exchange coinmarketcap       BTC     0.00000688
      7  CDC.exchange coinmarketcap       CRO     4.09869774
      8  CDC.exchange coinmarketcap       CRO     4.11382677
      9  CDC.exchange coinmarketcap       CRO     4.16733907
      10 CDC.exchange coinmarketcap       CRO     4.18255217
                                            suploss.range quantity.60days
      1  2021-01-20 00:00:00 UTC--2021-03-21 00:00:00 UTC               0
      2  2021-01-22 00:00:00 UTC--2021-03-23 00:00:00 UTC               0
      3  2021-03-16 16:04:21 UTC--2021-05-15 16:04:21 UTC               0
      4  2021-03-19 00:00:00 UTC--2021-05-18 00:00:00 UTC               0
      5  2021-04-14 06:02:22 UTC--2021-06-13 06:02:22 UTC               0
      6  2021-05-13 15:21:34 UTC--2021-07-12 15:21:34 UTC               0
      7  2021-05-28 01:34:00 UTC--2021-07-27 01:34:00 UTC               0
      8  2021-06-07 00:00:00 UTC--2021-08-06 00:00:00 UTC               0
      9  2021-06-13 00:00:00 UTC--2021-08-12 00:00:00 UTC               0
      10 2021-08-08 00:00:00 UTC--2021-10-07 00:00:00 UTC               0
         share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1    2.73457464                 0    FALSE     0.00000000000        NA
      2    2.73457464                 0    FALSE     0.00000000000        NA
      3    0.00000058                 0    FALSE     0.00000000000        NA
      4    4.09969774                 0    FALSE     0.00000000000        NA
      5    0.00000688                 0    FALSE     0.00000000000        NA
      6    0.00000688                 0    FALSE     0.00000000000        NA
      7    4.16733907                 0    FALSE    -0.00008184142        NA
      8    4.16733907                 0    FALSE     0.00000000000        NA
      9    4.16733907                 0    FALSE     0.00000000000        NA
      10   4.18255217                 0    FALSE     0.00000000000        NA
         gains.excess          gains        ACB     ACB.share
      1            NA             NA 0.22279000     0.1632014
      2            NA             NA 0.46390958     0.1696460
      3            NA             NA 0.01821493 79195.3367033
      4            NA             NA 0.84379960     0.2058200
      5            NA             NA 0.03936626 67872.8632600
      6            NA             NA 0.31848016 46290.7216070
      7            NA -0.00008184142 0.84359378     0.2058200
      8            NA             NA 0.84359378     0.2050630
      9            NA             NA 0.84359378     0.2024298
      10           NA             NA 0.84359378     0.2016935

# CDC wallet

    Code
      formatted.CDC.wallet
    Output
                       date currency quantity   total.price spot.rate transaction
      1 2021-04-12 18:28:50      CRO 0.512510 0.13593610436 0.2652360     revenue
      2 2021-04-23 18:51:53      CRO 1.656708 0.36013687043 0.2173811     revenue
      3 2021-05-21 01:19:01      CRO 0.000200 0.00002993323 0.1496661        sell
      4 2021-06-26 14:51:02      CRO 6.051235 0.70769054418 0.1169498     revenue
        fees description                                            comment
      1    0      Reward                         Auto Withdraw Reward from 
      2    0      Reward                         Auto Withdraw Reward from 
      3    0  Withdrawal Outgoing Transaction to abcdefghijklmnopqrstuvwxyz
      4    0      Reward    Withdraw Reward from abcdefghijklmnopqrstuvwxyz
        revenue.type         value   exchange   rate.source currency2 total.quantity
      1      staking 0.13593610436 CDC.wallet coinmarketcap       CRO       0.512510
      2      staking 0.36013687043 CDC.wallet coinmarketcap       CRO       2.169218
      3         <NA> 0.00002993323 CDC.wallet coinmarketcap       CRO       2.169018
      4      staking 0.70769054418 CDC.wallet coinmarketcap       CRO       8.220253
                                           suploss.range quantity.60days share.left60
      1 2021-03-13 18:28:50 UTC--2021-05-12 18:28:50 UTC               0     2.169218
      2 2021-03-24 18:51:53 UTC--2021-05-23 18:51:53 UTC               0     2.169018
      3 2021-04-21 01:19:01 UTC--2021-06-20 01:19:01 UTC               0     2.169018
      4 2021-05-27 14:51:02 UTC--2021-07-26 14:51:02 UTC               0     8.220253
        sup.loss.quantity sup.loss gains.uncorrected gains.sup gains.excess
      1                 0    FALSE     0.00000000000        NA           NA
      2                 0    FALSE     0.00000000000        NA           NA
      3                 0    FALSE    -0.00001580427        NA           NA
      4                 0    FALSE     0.00000000000        NA           NA
                 gains       ACB ACB.share
      1             NA 0.1359361 0.2652360
      2             NA 0.4960730 0.2286875
      3 -0.00001580427 0.4960272 0.2286875
      4             NA 1.2037178 0.1464332

# uphold

    Code
      formatted.uphold
    Output
                        date currency    quantity total.price   spot.rate transaction
      1  2021-01-07 02:40:31      BAT  1.59081275   0.0000000   0.3214875     revenue
      2  2021-02-09 14:26:49      BAT 12.69812163   0.0000000   0.5418583     revenue
      3  2021-03-06 21:32:36      BAT  0.37591275   0.0000000   0.8522910     revenue
      4  2021-03-07 21:46:57      BAT 52.59871206  57.0095475   1.0838582        sell
      5  2021-03-07 21:46:57      LTC  0.24129740  57.0095475 236.2625850         buy
      6  2021-03-07 21:54:09      LTC  0.00300000   0.7087878 236.2625850        sell
      7  2021-04-05 12:22:00      BAT  8.52198415   0.0000000   1.5504039     revenue
      8  2021-04-06 03:41:42      LTC  0.00300000   0.8643769 288.1256316        sell
      9  2021-04-06 04:47:00      BAT  8.52198415  10.3897561   1.2191710        sell
      10 2021-04-06 04:47:00      LTC  0.03605981  10.3897561 288.1256316         buy
      11 2021-05-11 07:12:24      BAT  0.47521985   0.0000000   1.6365606     revenue
      12 2021-06-09 04:52:23      BAT  0.67207415   0.0000000   0.8312183     revenue
         fees description         comment revenue.type      value exchange
      1     0          in            <NA>     airdrops  0.5114264   uphold
      2     0          in            <NA>     airdrops  6.8805827   uphold
      3     0          in            <NA>     airdrops  0.3203871   uphold
      4     0       trade         BAT-LTC         <NA> 57.0095475   uphold
      5     0       trade         BAT-LTC         <NA> 57.0095475   uphold
      6     0         out withdrawal fees         <NA>  0.7087878   uphold
      7     0          in            <NA>     airdrops 13.2125179   uphold
      8     0         out withdrawal fees         <NA>  0.8643769   uphold
      9     0       trade         BAT-LTC         <NA> 10.3897561   uphold
      10    0       trade         BAT-LTC         <NA> 10.3897561   uphold
      11    0          in            <NA>     airdrops  0.7777261   uphold
      12    0          in            <NA>     airdrops  0.5586404   uphold
                       rate.source currency2 total.quantity
      1              coinmarketcap       BAT      1.5908128
      2              coinmarketcap       BAT     14.2889344
      3              coinmarketcap       BAT     14.6648471
      4  coinmarketcap (buy price)       BAT    -37.9338649
      5              coinmarketcap       LTC      0.2412974
      6              coinmarketcap       LTC      0.2382974
      7              coinmarketcap       BAT    -29.4118808
      8              coinmarketcap       LTC      0.2352974
      9  coinmarketcap (buy price)       BAT    -37.9338649
      10             coinmarketcap       LTC      0.2713572
      11             coinmarketcap       BAT    -37.4586451
      12             coinmarketcap       BAT    -36.7865709
                                            suploss.range quantity.60days
      1  2020-12-08 02:40:31 UTC--2021-02-06 02:40:31 UTC       0.0000000
      2  2021-01-10 14:26:49 UTC--2021-03-11 14:26:49 UTC       0.0000000
      3  2021-02-04 21:32:36 UTC--2021-04-05 21:32:36 UTC       0.0000000
      4  2021-02-05 21:46:57 UTC--2021-04-06 21:46:57 UTC       0.0000000
      5  2021-02-05 21:46:57 UTC--2021-04-06 21:46:57 UTC       0.2773572
      6  2021-02-05 21:54:09 UTC--2021-04-06 21:54:09 UTC       0.2773572
      7  2021-03-06 12:22:00 UTC--2021-05-05 12:22:00 UTC       0.0000000
      8  2021-03-07 03:41:42 UTC--2021-05-06 03:41:42 UTC       0.2773572
      9  2021-03-07 04:47:00 UTC--2021-05-06 04:47:00 UTC       0.0000000
      10 2021-03-07 04:47:00 UTC--2021-05-06 04:47:00 UTC       0.2773572
      11 2021-04-11 07:12:24 UTC--2021-06-10 07:12:24 UTC       0.0000000
      12 2021-05-10 04:52:23 UTC--2021-07-09 04:52:23 UTC       0.0000000
         share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1     1.5908128             0.000    FALSE         0.0000000        NA
      2   -37.9338649             0.000    FALSE         0.0000000        NA
      3   -29.4118808             0.000    FALSE         0.0000000        NA
      4   -37.9338649             0.000    FALSE        57.0095475        NA
      5     0.2713572             0.000    FALSE         0.0000000        NA
      6     0.2713572             0.003    FALSE         0.0000000        NA
      7   -37.9338649             0.000    FALSE         0.0000000        NA
      8     0.2713572             0.003    FALSE         0.1555891        NA
      9   -37.9338649             0.000    FALSE        10.3897561        NA
      10    0.2713572             0.000    FALSE         0.0000000        NA
      11  -36.7865709             0.000    FALSE         0.0000000        NA
      12  -36.7865709             0.000    FALSE         0.0000000        NA
         gains.excess      gains      ACB ACB.share
      1            NA         NA  0.00000    0.0000
      2            NA         NA  0.00000    0.0000
      3            NA         NA  0.00000    0.0000
      4            NA 57.0095475  0.00000    0.0000
      5            NA         NA 57.00955  236.2626
      6            NA         NA 56.30076  236.2626
      7            NA         NA  0.00000    0.0000
      8            NA  0.1555891 55.59197  236.2626
      9            NA 10.3897561  0.00000    0.0000
      10           NA         NA 65.98173  243.1545
      11           NA         NA  0.00000    0.0000
      12           NA         NA  0.00000    0.0000

# gemini

    Code
      formatted.gemini
    Output
                        date currency        quantity total.price     spot.rate
      1  2021-04-08 22:22:22      LTC  1.000000000000 286.0000000   286.0000000
      2  2021-04-09 22:50:55      BTC  0.000966278356  70.6618968 73127.8895000
      3  2021-04-09 22:50:55      LTC  0.246690598398  70.6618968   286.4393588
      4  2021-04-09 22:53:57      BTC  0.000006051912   0.4425635 73127.8895000
      5  2021-04-09 22:53:57      LTC  0.001640820000   0.4425635   269.7209419
      6  2021-04-09 23:20:53      BAT 48.719519585106  86.3881744     1.7731738
      7  2021-04-09 23:20:53      BTC  0.000950730015  86.3881744 90865.0963117
      8  2021-04-10 23:22:04      BTC  0.000285025578   0.0000000 73954.0922149
      9  2021-05-08 16:14:54      BAT  2.833934780210   0.0000000     1.7142652
      10 2021-05-16 12:55:02      BAT  3.085288331282   0.0000000     1.3801796
      11 2021-05-16 13:35:19      BAT  5.007481461482   0.0000000     1.3801796
      12 2021-06-18 01:38:54      BAT  6.834322542857   0.0000000     0.7883027
         transaction            fees                     description
      1          buy 0.0000000000000 fake transaction for format_ACB
      2          buy 0.0000023034086                          LTCBTC
      3         sell 0.0000000000000                          LTCBTC
      4          buy 0.0000000365181                          LTCBTC
      5         sell 0.0000000000000                          LTCBTC
      6          buy 0.0000000000000                          BATBTC
      7         sell 0.0000018142411                          BATBTC
      8      revenue 0.0000000000000                          Credit
      9      revenue 0.0000000000000                          Credit
      10     revenue 0.0000000000000                          Credit
      11     revenue 0.0000000000000                          Credit
      12     revenue 0.0000000000000                          Credit
                       comment revenue.type       value exchange
      1                   <NA>         <NA> 286.0000000   gemini
      2                 Market         <NA>  70.6618968   gemini
      3                 Market         <NA>  70.6618968   gemini
      4                  Limit         <NA>   0.4425635   gemini
      5                  Limit         <NA>   0.4425635   gemini
      6                  Limit         <NA>  86.3881744   gemini
      7                  Limit         <NA>  86.3881744   gemini
      8  Administrative Credit    referrals  21.0788079   gemini
      9  Administrative Credit    referrals   4.8581158   gemini
      10               Deposit     airdrops   4.2582521   gemini
      11               Deposit     airdrops   6.9112238   gemini
      12               Deposit     airdrops   5.3875147   gemini
                       rate.source currency2 total.quantity
      1                       fake       LTC  1.00000000000
      2              coinmarketcap       BTC  0.00096627836
      3  coinmarketcap (buy price)       LTC  0.75330940160
      4              coinmarketcap       BTC  0.00097233027
      5  coinmarketcap (buy price)       LTC  0.75166858160
      6              coinmarketcap       BAT 48.71951958511
      7  coinmarketcap (buy price)       BTC  0.00002160025
      8              coinmarketcap       BTC  0.00030662583
      9              coinmarketcap       BAT 51.55345436532
      10             coinmarketcap       BAT 54.63874269660
      11             coinmarketcap       BAT 59.64622415808
      12             coinmarketcap       BAT 66.48054670094
                                            suploss.range quantity.60days
      1  2021-03-09 22:22:22 UTC--2021-05-08 22:22:22 UTC    1.0000000000
      2  2021-03-10 22:50:55 UTC--2021-05-09 22:50:55 UTC    0.0009723303
      3  2021-03-10 22:50:55 UTC--2021-05-09 22:50:55 UTC    1.0000000000
      4  2021-03-10 22:53:57 UTC--2021-05-09 22:53:57 UTC    0.0009723303
      5  2021-03-10 22:53:57 UTC--2021-05-09 22:53:57 UTC    1.0000000000
      6  2021-03-10 23:20:53 UTC--2021-05-09 23:20:53 UTC   48.7195195851
      7  2021-03-10 23:20:53 UTC--2021-05-09 23:20:53 UTC    0.0009723303
      8  2021-03-11 23:22:04 UTC--2021-05-10 23:22:04 UTC    0.0009723303
      9  2021-04-08 16:14:54 UTC--2021-06-07 16:14:54 UTC   48.7195195851
      10 2021-04-16 12:55:02 UTC--2021-06-15 12:55:02 UTC    0.0000000000
      11 2021-04-16 13:35:19 UTC--2021-06-15 13:35:19 UTC    0.0000000000
      12 2021-05-19 01:38:54 UTC--2021-07-18 01:38:54 UTC    0.0000000000
          share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1   0.7516685816        0.00000000    FALSE         0.0000000        NA
      2   0.0003066258        0.00000000    FALSE         0.0000000        NA
      3   0.7516685816        0.24669060    FALSE         0.1083857        NA
      4   0.0003066258        0.00000000    FALSE         0.0000000        NA
      5   0.7516685816        0.00164082     TRUE        -0.0267110 -0.026711
      6  51.5534543653        0.00000000    FALSE         0.0000000        NA
      7   0.0003066258        0.00095073    FALSE        16.8632908        NA
      8   0.0003066258        0.00000000    FALSE         0.0000000        NA
      9  59.6462241581        0.00000000    FALSE         0.0000000        NA
      10 59.6462241581        0.00000000    FALSE         0.0000000        NA
      11 59.6462241581        0.00000000    FALSE         0.0000000        NA
      12 66.4805467009        0.00000000    FALSE         0.0000000        NA
         gains.excess      gains        ACB    ACB.share
      1            NA         NA 286.000000   286.000000
      2            NA         NA  70.661899 73127.891884
      3            NA  0.1083857 215.446489   286.000000
      4            NA         NA  71.104463 73127.891906
      5            NA         NA 215.003925   286.035536
      6            NA         NA  86.388174     1.773174
      7            NA 16.8632908   1.579581 73127.891906
      8            NA         NA   1.579581  5151.493263
      9            NA         NA  86.388174     1.675701
      10           NA         NA  86.388174     1.581079
      11           NA         NA  86.388174     1.448343
      12           NA         NA  86.388174     1.299450

# exodus

    Code
      formatted.exodus
    Output
                       date currency  quantity total.price    spot.rate transaction
      1 2021-04-25 22:06:11      LTC 0.0028860   0.6412590   222.196455         buy
      2 2021-04-25 23:08:12      ADA 0.3564820   0.6675172     1.872513         buy
      3 2021-05-12 12:15:28      BTC 0.0001006   4.4569617 44303.794280         buy
      4 2021-05-12 22:31:35      ETH 0.0029000   8.3322534  2873.190813         buy
      5 2021-05-25 22:06:11      LTC 0.0014430   0.3206295   222.196455        sell
      6 2021-05-25 23:08:12      ADA 0.1782410   0.3337586     1.872513        sell
      7 2021-06-12 12:15:28      BTC 0.0000503   2.2284809 44303.794280        sell
      8 2021-06-12 22:31:35      ETH 0.0014500   4.1661267  2873.190813        sell
        fees                     description revenue.type     value exchange
      1    0 fake transaction for format_ACB         <NA> 0.6412590   exodus
      2    0 fake transaction for format_ACB         <NA> 0.6675172   exodus
      3    0 fake transaction for format_ACB         <NA> 4.4569617   exodus
      4    0 fake transaction for format_ACB         <NA> 8.3322534   exodus
      5    0                      withdrawal         <NA> 0.3206295   exodus
      6    0                      withdrawal         <NA> 0.3337586   exodus
      7    0                      withdrawal         <NA> 2.2284809   exodus
      8    0                      withdrawal         <NA> 4.1661267   exodus
          rate.source currency2 total.quantity
      1 coinmarketcap       LTC      0.0028860
      2 coinmarketcap       ADA      0.3564820
      3 coinmarketcap       BTC      0.0001006
      4 coinmarketcap       ETH      0.0029000
      5 coinmarketcap       LTC      0.0014430
      6 coinmarketcap       ADA      0.1782410
      7 coinmarketcap       BTC      0.0000503
      8 coinmarketcap       ETH      0.0014500
                                           suploss.range quantity.60days share.left60
      1 2021-03-26 22:06:11 UTC--2021-05-25 22:06:11 UTC       0.0028860    0.0014430
      2 2021-03-26 23:08:12 UTC--2021-05-25 23:08:12 UTC       0.3564820    0.1782410
      3 2021-04-12 12:15:28 UTC--2021-06-11 12:15:28 UTC       0.0001006    0.0001006
      4 2021-04-12 22:31:35 UTC--2021-06-11 22:31:35 UTC       0.0029000    0.0029000
      5 2021-04-25 22:06:11 UTC--2021-06-24 22:06:11 UTC       0.0028860    0.0014430
      6 2021-04-25 23:08:12 UTC--2021-06-24 23:08:12 UTC       0.3564820    0.1782410
      7 2021-05-13 12:15:28 UTC--2021-07-12 12:15:28 UTC       0.0000000    0.0000503
      8 2021-05-13 22:31:35 UTC--2021-07-12 22:31:35 UTC       0.0000000    0.0014500
        sup.loss.quantity sup.loss gains.uncorrected gains.sup gains.excess gains
      1          0.000000    FALSE                 0        NA           NA    NA
      2          0.000000    FALSE                 0        NA           NA    NA
      3          0.000000    FALSE                 0        NA           NA    NA
      4          0.000000    FALSE                 0        NA           NA    NA
      5          0.001443    FALSE                 0        NA           NA    NA
      6          0.178241    FALSE                 0        NA           NA    NA
      7          0.000000    FALSE                 0        NA           NA    NA
      8          0.000000    FALSE                 0        NA           NA    NA
              ACB    ACB.share
      1 0.6412590   222.196455
      2 0.6675172     1.872513
      3 4.4569617 44303.794280
      4 8.3322534  2873.190813
      5 0.3206295   222.196455
      6 0.3337586     1.872513
      7 2.2284809 44303.794280
      8 4.1661267  2873.190813

# binance

    Code
      formatted.binance
    Output
                        date currency   quantity     total.price   spot.rate
      1  2021-03-08 22:22:22      ETH 1.00000000 3098.1375390000 3098.137539
      2  2021-03-08 22:22:22     USDC 5.77124200    7.7365230000    1.340530
      3  2021-05-29 17:07:20      ETH 0.19521000  521.6626161494 2672.315026
      4  2021-05-29 17:07:20      ETH 0.14123140  496.9598722014 3518.763336
      5  2021-05-29 17:07:20      ETH 0.11240000  298.9876732054 2660.032680
      6  2021-05-29 17:07:20      ETH 0.10512900  292.7656309433 2784.822751
      7  2021-05-29 17:07:20      ETH 0.00899120   61.8083668423 6874.317871
      8  2021-05-29 17:07:20      ETH 0.00612410   55.6275301581 9083.380441
      9  2021-05-29 17:07:20      LTC 2.53200000  521.6626161494  206.027889
      10 2021-05-29 17:07:20      LTC 2.41210000  496.9598722014  206.027889
      11 2021-05-29 17:07:20      LTC 1.45120000  298.9876732054  206.027889
      12 2021-05-29 17:07:20      LTC 1.42100000  292.7656309433  206.027889
      13 2021-05-29 17:07:20      LTC 0.30000000   61.8083668423  206.027889
      14 2021-05-29 17:07:20      LTC 0.27000000   55.6275301581  206.027889
      15 2021-05-29 17:07:20      LTC 0.00202500    0.0000000000  206.027889
      16 2021-05-29 17:07:20      LTC 0.00127520    0.0000000000  206.027889
      17 2021-05-29 17:07:20      LTC 0.00113100    0.0000000000  206.027889
      18 2021-05-29 17:07:20      LTC 0.00049230    0.0000000000  206.027889
      19 2021-05-29 17:07:20      LTC 0.00007000    0.0000000000  206.027889
      20 2021-05-29 17:07:20      LTC 0.00005000    0.0000000000  206.027889
      21 2021-05-29 18:12:55      ETH 0.44124211 1250.5929350551 2834.255631
      22 2021-05-29 18:12:55      ETH 0.42124000 1193.9018421488 2834.255631
      23 2021-05-29 18:12:55      ETH 0.00021470    0.0000000000 2834.255631
      24 2021-05-29 18:12:55      ETH 0.00009251    0.0000000000 2834.255631
      25 2021-05-29 18:12:55      LTC 1.60000000 1250.5929350551  781.620584
      26 2021-05-29 18:12:55      LTC 1.23000000 1193.9018421488  970.651904
      27 2021-11-05 04:32:23     BUSD 0.10512330    0.1309574574    1.245751
      28 2022-11-17 11:54:25     ETHW 0.00012050    0.0006084561    5.049428
      29 2022-11-27 08:05:35     BUSD 5.77124200    7.7365241364    1.340530
      30 2022-11-27 08:05:35     USDC 5.77124200    7.7366916521    1.340559
         transaction       fees                     description comment revenue.type
      1          buy 0.00000000 fake transaction for format_ACB    <NA>         <NA>
      2          buy 0.00000000 fake transaction for format_ACB    <NA>         <NA>
      3         sell 0.00000000                             Buy    Spot         <NA>
      4         sell 0.00000000                             Buy    Spot         <NA>
      5         sell 0.00000000                             Buy    Spot         <NA>
      6         sell 0.00000000                             Buy    Spot         <NA>
      7         sell 0.00000000                             Buy    Spot         <NA>
      8         sell 0.00000000                             Buy    Spot         <NA>
      9          buy 1.52893297                             Buy    Spot         <NA>
      10         buy 1.19743409                             Buy    Spot         <NA>
      11         buy 1.11687719                             Buy    Spot         <NA>
      12         buy 0.64342510                             Buy    Spot         <NA>
      13         buy 0.06180837                             Buy    Spot         <NA>
      14         buy 0.04326586                             Buy    Spot         <NA>
      15     revenue 0.00000000               Referral Kickback    Spot      rebates
      16     revenue 0.00000000               Referral Kickback    Spot      rebates
      17     revenue 0.00000000               Referral Kickback    Spot      rebates
      18     revenue 0.00000000               Referral Kickback    Spot      rebates
      19     revenue 0.00000000               Referral Kickback    Spot      rebates
      20     revenue 0.00000000               Referral Kickback    Spot      rebates
      21         buy 6.01747615                            Sell    Spot         <NA>
      22         buy 1.73569815                            Sell    Spot         <NA>
      23     revenue 0.00000000               Referral Kickback    Spot      rebates
      24     revenue 0.00000000               Referral Kickback    Spot      rebates
      25        sell 0.00000000                            Sell    Spot         <NA>
      26        sell 0.00000000                            Sell    Spot         <NA>
      27     revenue 0.00000000   Simple Earn Flexible Interest    Earn    interests
      28     revenue 0.00000000                    Distribution    Spot        forks
      29         buy 0.00000000     Stablecoins Auto-Conversion    Spot         <NA>
      30        sell 0.00000000     Stablecoins Auto-Conversion    Spot         <NA>
                   value exchange               rate.source currency2 total.quantity
      1  3098.1375390000  binance                      fake       ETH      1.0000000
      2     7.7365230000  binance                      fake      USDC      5.7712420
      3   521.6626161494  binance coinmarketcap (buy price)       ETH      0.8047900
      4   496.9598722014  binance coinmarketcap (buy price)       ETH      0.6635586
      5   298.9876732054  binance coinmarketcap (buy price)       ETH      0.5511586
      6   292.7656309433  binance coinmarketcap (buy price)       ETH      0.4460296
      7    61.8083668423  binance coinmarketcap (buy price)       ETH      0.4370384
      8    55.6275301581  binance coinmarketcap (buy price)       ETH      0.4309143
      9   521.6626161494  binance             coinmarketcap       LTC      2.5320000
      10  496.9598722014  binance             coinmarketcap       LTC      4.9441000
      11  298.9876732054  binance             coinmarketcap       LTC      6.3953000
      12  292.7656309433  binance             coinmarketcap       LTC      7.8163000
      13   61.8083668423  binance             coinmarketcap       LTC      8.1163000
      14   55.6275301581  binance             coinmarketcap       LTC      8.3863000
      15    0.4172064762  binance             coinmarketcap       LTC      8.3883250
      16    0.2627267647  binance             coinmarketcap       LTC      8.3896002
      17    0.2330175430  binance             coinmarketcap       LTC      8.3907312
      18    0.1014275300  binance             coinmarketcap       LTC      8.3912235
      19    0.0144219523  binance             coinmarketcap       LTC      8.3912935
      20    0.0103013945  binance             coinmarketcap       LTC      8.3913435
      21 1250.5929350551  binance             coinmarketcap       ETH      0.8721564
      22 1193.9018421488  binance             coinmarketcap       ETH      1.2933964
      23    0.6085146841  binance             coinmarketcap       ETH      1.2936111
      24    0.2621969885  binance             coinmarketcap       ETH      1.2937036
      25 1250.5929350551  binance coinmarketcap (buy price)       LTC      6.7913435
      26 1193.9018421488  binance coinmarketcap (buy price)       LTC      5.5613435
      27    0.1309574574  binance             coinmarketcap      BUSD      0.1051233
      28    0.0006084561  binance             coinmarketcap      ETHW      0.0001205
      29    7.7365241364  binance             coinmarketcap      BUSD      5.8763653
      30    7.7366916521  binance             coinmarketcap      USDC      0.0000000
                                            suploss.range quantity.60days
      1  2021-02-06 22:22:22 UTC--2021-04-07 22:22:22 UTC       1.0000000
      2  2021-02-06 22:22:22 UTC--2021-04-07 22:22:22 UTC       5.7712420
      3  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      4  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      5  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      6  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      7  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      8  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       0.8624821
      9  2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      10 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      11 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      12 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      13 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      14 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      15 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      16 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      17 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      18 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      19 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      20 2021-04-29 17:07:20 UTC--2021-06-28 17:07:20 UTC       8.3863000
      21 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       0.8624821
      22 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       0.8624821
      23 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       0.8624821
      24 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       0.8624821
      25 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       8.3863000
      26 2021-04-29 18:12:55 UTC--2021-06-28 18:12:55 UTC       8.3863000
      27 2021-10-06 04:32:23 UTC--2021-12-05 04:32:23 UTC       0.0000000
      28 2022-10-18 11:54:25 UTC--2022-12-17 11:54:25 UTC       0.0000000
      29 2022-10-28 08:05:35 UTC--2022-12-27 08:05:35 UTC       5.7712420
      30 2022-10-28 08:05:35 UTC--2022-12-27 08:05:35 UTC       0.0000000
         share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1     1.0000000         0.0000000    FALSE      0.0000000000        NA
      2     5.7712420         0.0000000    FALSE      0.0000000000        NA
      3     1.2937036         0.1952100     TRUE    -83.1248128388 -83.12481
      4     1.2937036         0.1412314    FALSE     44.8181204164        NA
      5     1.2937036         0.1124000     TRUE    -60.8525103561 -60.85251
      6     1.2937036         0.1051290     TRUE    -55.4041097531 -55.40411
      7     1.2937036         0.0089912    FALSE     30.9141569078        NA
      8     1.2937036         0.0061241    FALSE     34.5848182776        NA
      9     5.5613435         0.0000000    FALSE      0.0000000000        NA
      10    5.5613435         0.0000000    FALSE      0.0000000000        NA
      11    5.5613435         0.0000000    FALSE      0.0000000000        NA
      12    5.5613435         0.0000000    FALSE      0.0000000000        NA
      13    5.5613435         0.0000000    FALSE      0.0000000000        NA
      14    5.5613435         0.0000000    FALSE      0.0000000000        NA
      15    5.5613435         0.0000000    FALSE      0.0000000000        NA
      16    5.5613435         0.0000000    FALSE      0.0000000000        NA
      17    5.5613435         0.0000000    FALSE      0.0000000000        NA
      18    5.5613435         0.0000000    FALSE      0.0000000000        NA
      19    5.5613435         0.0000000    FALSE      0.0000000000        NA
      20    5.5613435         0.0000000    FALSE      0.0000000000        NA
      21    1.2937036         0.0000000    FALSE      0.0000000000        NA
      22    1.2937036         0.0000000    FALSE      0.0000000000        NA
      23    1.2937036         0.0000000    FALSE      0.0000000000        NA
      24    1.2937036         0.0000000    FALSE      0.0000000000        NA
      25    5.5613435         1.6000000    FALSE    920.2709201219        NA
      26    5.5613435         1.2300000    FALSE    939.9667931689        NA
      27    0.1051233         0.0000000    FALSE      0.0000000000        NA
      28    0.0001205         0.0000000    FALSE      0.0000000000        NA
      29    5.8763653         0.0000000    FALSE      0.0000000000        NA
      30    0.0000000         0.0000000    FALSE      0.0001686521        NA
         gains.excess          gains             ACB   ACB.share
      1            NA             NA 3098.1375390000 3098.137539
      2            NA             NA    7.7365230000    1.340530
      3            NA             NA 2576.4749228506 3201.425121
      4            NA  44.8181204164 2124.3331710656 3201.425121
      5            NA             NA 1825.3454978602 3311.833468
      6            NA             NA 1532.5798669169 3436.049686
      7            NA  30.9141569078 1501.6856569824 3436.049686
      8            NA  34.5848182776 1480.6429451018 3436.049686
      9            NA             NA  523.1915491172  206.631733
      10           NA             NA 1021.3488554122  206.579328
      11           NA             NA 1321.4534058065  206.628838
      12           NA             NA 1614.8624618485  206.601904
      13           NA             NA 1676.7326370577  206.588302
      14           NA             NA 1732.4034330726  206.575419
      15           NA             NA 1732.4034330726  206.525550
      16           NA             NA 1732.4034330726  206.494158
      17           NA             NA 1732.4034330726  206.466325
      18           NA             NA 1732.4034330726  206.454212
      19           NA             NA 1732.4034330726  206.452489
      20           NA             NA 1732.4034330726  206.451259
      21           NA             NA 2737.2533563100 3138.489066
      22           NA             NA 3932.8908966074 3040.746724
      23           NA             NA 3932.8908966074 3040.242053
      24           NA             NA 3932.8908966074 3040.024652
      25           NA 920.2709201219 1402.0814181395  206.451259
      26           NA 939.9667931689 1148.1463691596  206.451259
      27           NA             NA    0.1309574574    1.245751
      28           NA             NA    0.0006084561    5.049428
      29           NA             NA    7.8674815938    1.338835
      30           NA   0.0001686521    0.0000000000    0.000000

# binance withdrawals

    Code
      formatted.binance.withdrawals
    Output
                       date currency quantity total.price spot.rate transaction fees
      1 2021-03-28 17:13:50      LTC 0.002000   0.6403742  320.1871         buy    0
      2 2021-03-28 18:15:14      ETH 0.000142   0.4746407 3342.5405         buy    0
      3 2021-04-06 19:55:52      ETH 0.000124   0.5312236 4284.0612         buy    0
      4 2021-04-28 17:13:50      LTC 0.001000   0.3201871  320.1871        sell    0
      5 2021-04-28 18:15:14      ETH 0.000071   0.2373204 3342.5405        sell    0
      6 2021-05-06 19:55:52      ETH 0.000062   0.2656118 4284.0612        sell    0
                            description exchange   rate.source currency2
      1 fake transaction for format_ACB  binance coinmarketcap       LTC
      2 fake transaction for format_ACB  binance coinmarketcap       ETH
      3 fake transaction for format_ACB  binance coinmarketcap       ETH
      4                 Withdrawal fees  binance coinmarketcap       LTC
      5                 Withdrawal fees  binance coinmarketcap       ETH
      6                 Withdrawal fees  binance coinmarketcap       ETH
        total.quantity                                    suploss.range
      1       0.002000 2021-02-26 17:13:50 UTC--2021-04-27 17:13:50 UTC
      2       0.000142 2021-02-26 18:15:14 UTC--2021-04-27 18:15:14 UTC
      3       0.000266 2021-03-07 19:55:52 UTC--2021-05-06 19:55:52 UTC
      4       0.001000 2021-03-29 17:13:50 UTC--2021-05-28 17:13:50 UTC
      5       0.000195 2021-03-29 18:15:14 UTC--2021-05-28 18:15:14 UTC
      6       0.000133 2021-04-06 19:55:52 UTC--2021-06-05 19:55:52 UTC
        quantity.60days share.left60 sup.loss.quantity sup.loss gains.uncorrected
      1        0.002000     0.002000          0.000000    FALSE        0.00000000
      2        0.000266     0.000266          0.000000    FALSE        0.00000000
      3        0.000266     0.000133          0.000000    FALSE        0.00000000
      4        0.000000     0.001000          0.000000    FALSE        0.00000000
      5        0.000124     0.000133          0.000071     TRUE       -0.03116221
      6        0.000124     0.000133          0.000062    FALSE        0.02125423
          gains.sup gains.excess      gains       ACB ACB.share
      1          NA           NA         NA 0.6403742  320.1871
      2          NA           NA         NA 0.4746407 3342.5405
      3          NA           NA         NA 1.0058643 3781.4449
      4          NA           NA         NA 0.3201871  320.1871
      5 -0.03116221           NA         NA 0.7685440 3941.2511
      6          NA           NA 0.02125423 0.5241864 3941.2511

# CDC exchange trades

    Code
      formatted.CDC.exchange.trades
    Output
                        date currency   quantity total.price    spot.rate transaction
      1  2021-03-08 22:22:22      ETH     1.0000  3098.13754 3098.1375390         buy
      2  2021-12-24 15:34:45      CRO 13260.1300 10386.66313    0.7833002         buy
      3  2021-12-24 15:34:45      CRO  3555.9000  2785.33736    0.7833002         buy
      4  2021-12-24 15:34:45      CRO  1781.7400  1395.63739    0.7833002         buy
      5  2021-12-24 15:34:45      CRO    26.8500    21.03161    0.7833002         buy
      6  2021-12-24 15:34:45      CRO    26.6700    20.89062    0.7833002         buy
      7  2021-12-24 15:34:45      CRO    17.7800    13.92708    0.7833002         buy
      8  2021-12-24 15:34:45      CRO    17.7800    13.92708    0.7833002         buy
      9  2021-12-24 15:34:45      ETH     2.0932 10386.66313 4962.0978083        sell
      10 2021-12-24 15:34:45      ETH     0.5600  2785.33736 4973.8167068        sell
      11 2021-12-24 15:34:45      ETH     0.2800  1395.63739 4984.4192352        sell
      12 2021-12-24 15:34:45      ETH     0.0042    21.03161 5007.5265925        sell
      13 2021-12-24 15:34:45      ETH     0.0042    20.89062 4973.9565819        sell
      14 2021-12-24 15:34:45      ETH     0.0028    13.92708 4973.9565819        sell
      15 2021-12-24 15:34:45      ETH     0.0028    13.92708 4973.9565819        sell
                fees                     description comment     exchange
      1   0.00000000 fake transaction for format_ACB    <NA> CDC.exchange
      2   0.00000000                             BUY ETH_CRO CDC.exchange
      3   0.00000000                             BUY ETH_CRO CDC.exchange
      4   0.00000000                             BUY ETH_CRO CDC.exchange
      5   0.00000000                             BUY ETH_CRO CDC.exchange
      6   0.00000000                             BUY ETH_CRO CDC.exchange
      7   0.00000000                             BUY ETH_CRO CDC.exchange
      8   0.00000000                             BUY ETH_CRO CDC.exchange
      9  41.54665616                            SELL ETH_CRO CDC.exchange
      10 11.14134692                            SELL ETH_CRO CDC.exchange
      11  5.58256082                            SELL ETH_CRO CDC.exchange
      12  0.08413730                            SELL ETH_CRO CDC.exchange
      13  0.08355905                            SELL ETH_CRO CDC.exchange
      14  0.05570691                            SELL ETH_CRO CDC.exchange
      15  0.05570683                            SELL ETH_CRO CDC.exchange
                       rate.source currency2 total.quantity
      1                       fake       ETH         1.0000
      2              coinmarketcap       CRO     13260.1300
      3              coinmarketcap       CRO     16816.0300
      4              coinmarketcap       CRO     18597.7700
      5              coinmarketcap       CRO     18624.6200
      6              coinmarketcap       CRO     18651.2900
      7              coinmarketcap       CRO     18669.0700
      8              coinmarketcap       CRO     18686.8500
      9  coinmarketcap (buy price)       ETH        -1.0932
      10 coinmarketcap (buy price)       ETH        -1.6532
      11 coinmarketcap (buy price)       ETH        -1.9332
      12 coinmarketcap (buy price)       ETH        -1.9374
      13 coinmarketcap (buy price)       ETH        -1.9416
      14 coinmarketcap (buy price)       ETH        -1.9444
      15 coinmarketcap (buy price)       ETH        -1.9472
                                            suploss.range quantity.60days
      1  2021-02-06 22:22:22 UTC--2021-04-07 22:22:22 UTC            1.00
      2  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      3  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      4  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      5  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      6  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      7  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      8  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC        18686.85
      9  2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      10 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      11 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      12 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      13 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      14 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
      15 2021-11-24 15:34:45 UTC--2022-01-23 15:34:45 UTC            0.00
         share.left60 sup.loss.quantity sup.loss gains.uncorrected gains.sup
      1        1.0000                 0    FALSE           0.00000        NA
      2    18686.8500                 0    FALSE           0.00000        NA
      3    18686.8500                 0    FALSE           0.00000        NA
      4    18686.8500                 0    FALSE           0.00000        NA
      5    18686.8500                 0    FALSE           0.00000        NA
      6    18686.8500                 0    FALSE           0.00000        NA
      7    18686.8500                 0    FALSE           0.00000        NA
      8    18686.8500                 0    FALSE           0.00000        NA
      9       -1.9472                 0    FALSE        3860.09498        NA
      10      -1.9472                 0    FALSE        2774.19601        NA
      11      -1.9472                 0    FALSE        1390.05483        NA
      12      -1.9472                 0    FALSE          20.94747        NA
      13      -1.9472                 0    FALSE          20.80706        NA
      14      -1.9472                 0    FALSE          13.87137        NA
      15      -1.9472                 0    FALSE          13.87137        NA
         gains.excess      gains       ACB    ACB.share
      1            NA         NA  3098.138 3098.1375390
      2            NA         NA 10386.663    0.7833002
      3            NA         NA 13172.000    0.7833002
      4            NA         NA 14567.638    0.7833002
      5            NA         NA 14588.669    0.7833002
      6            NA         NA 14609.560    0.7833002
      7            NA         NA 14623.487    0.7833002
      8            NA         NA 14637.414    0.7833002
      9            NA 3860.09498 -3386.884    0.0000000
      10           NA 2774.19601 -5121.841    0.0000000
      11           NA 1390.05483 -5989.319    0.0000000
      12           NA   20.94747 -6002.332    0.0000000
      13           NA   20.80706 -6015.344    0.0000000
      14           NA   13.87137 -6024.019    0.0000000
      15           NA   13.87137 -6032.693    0.0000000

