% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinmarketcap.R
\name{coinmarketcap_metadata}
\alias{coinmarketcap_metadata}
\title{coinmarketcap_metadata}
\usage{
coinmarketcap_metadata(
  api_key,
  id = NULL,
  slug = NULL,
  symbol = NULL,
  address = NULL,
  aux = "urls,logo,description,tags,platform,date_added,notice,status"
)
}
\arguments{
\item{api_key}{your CoinMarketCap API key}

\item{id}{the id of the asset you wish to query. The default value is NULL;
however, each request must include either an id, slug, symbol, or contract
address. You can also pass multiple comma-separated values.}

\item{slug}{the slug of the asset you wish to query. The default value is
NULL. You can also pass multiple comma-separated values.}

\item{symbol}{the symbol of the asset you wish to query. The default value is
NULL. You can also pass multiple comma-separated values.}

\item{address}{the contract address of the asset you wish to query.
The default calue is NULL. You can also pass multiple comma-separated values.}

\item{aux}{Optionally specify a comma-separated list of supplemental data
fields to return. Pass "urls,logo,description,tags,platform,date_added,
notice,status" to include all auxiliary fields. This function will include
all auxiliary fields by default.}
}
\value{
returns a list which includes a dataframe for each asset you
requested. The dataframe will contain CoinMarketCap metadata for the asset.
}
\description{
coinmarketcap_metadata
}
\examples{
\dontrun{
api_key <- "..."
metadata <- coinmarketcap_metadata(api_key, symbol = "BTC")}
}
