/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.Collection;
import java.util.Iterator;

public class FeatureDatasetFactory {
    public static FeatureCollection createFromGeometry(Collection geoms) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            feature.setGeometry((Geometry)i.next());
            fc.add(feature);
        }
        return fc;
    }

    public static FeatureDataset createFromGeometryWithLength(Collection geoms, String attrName) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(attrName, AttributeType.DOUBLE);
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            Geometry g = (Geometry)i.next();
            feature.setGeometry(g);
            feature.setAttribute(attrName, (Object)new Double(g.getLength()));
            fc.add(feature);
        }
        return fc;
    }

    public static FeatureDataset createFromGeometry(Collection geoms, FeatureSchema featureSchema) {
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            feature.setGeometry((Geometry)i.next());
            fc.add(feature);
        }
        return fc;
    }

    public static FeatureDataset createFromGeometryWithLengthAndArea(Collection geoms, String attrNameLen, String attrNameArea) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        if (attrNameLen != null) {
            featureSchema.addAttribute(attrNameLen, AttributeType.DOUBLE);
        }
        if (attrNameArea != null) {
            featureSchema.addAttribute(attrNameArea, AttributeType.DOUBLE);
        }
        FeatureDataset fc = new FeatureDataset(featureSchema);
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            BasicFeature feature = new BasicFeature(fc.getFeatureSchema());
            Geometry g = (Geometry)i.next();
            feature.setGeometry(g);
            if (attrNameLen != null) {
                feature.setAttribute(attrNameLen, (Object)new Double(g.getLength()));
            }
            if (attrNameArea != null) {
                feature.setAttribute(attrNameArea, (Object)new Double(g.getArea()));
            }
            fc.add(feature);
        }
        return fc;
    }
}

