/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FeatureUtil {
    private static int lastID = 0;

    public static Feature toFeature(Geometry g, FeatureSchema schema) {
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry(g);
        return feature;
    }

    public static List toGeometries(Collection features) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        Iterator i = features.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            list.add(feature.getGeometry());
        }
        return list;
    }

    public static int nextID() {
        return ++lastID;
    }

    public static void copyAttributes(Feature a, Feature b) {
        for (int i = 0; i < a.getSchema().getAttributeCount(); ++i) {
            b.setAttribute(i, a.getAttribute(i));
        }
    }

    public static boolean areAllNonSpatialAttributesNull(Feature feature) {
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            if (AttributeType.GEOMETRY == feature.getSchema().getAttributeType(i) || feature.getAttribute(i) == null) continue;
            return false;
        }
        return true;
    }

    public static class IDComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            if (f1.getID() < f2.getID()) {
                return -1;
            }
            if (f1.getID() > f2.getID()) {
                return 1;
            }
            return 0;
        }
    }
}

