% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_geo.R
\name{cso_get_geo_meta}
\alias{cso_get_geo_meta}
\title{Returns a data frame with the metadata of a vector shapefile}
\usage{
cso_get_geo_meta(shp)
}
\arguments{
\item{shp}{sf data.frame. Geographic data stored as an sf object.}
}
\value{
list with eight elements:
\itemize{
  \item The coordinate reference system, itself a list with two elements,
  the EPSG code (if any, NA value if none), and the proj4string
  \item The number of polygons in the data
  \item If all the polygons are simple (not self-intersecting)
  \item If any polygons are empty
  \item If all of the polygons are valid
  \item The average area of the polygons, including units
}
}
\description{
Takes the output from \code{\link{cso_get_geo}} or otherwise and returns
information about it in a data frame.
}
\examples{
\dontrun{
shp_meta <- cso_get_geo_meta(shp)
}
}
