% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csodata.R
\docType{package}
\name{csodata}
\alias{csodata}
\alias{csodata-package}
\title{csodata: A package for downloading CSO data.}
\description{
The csodata package allows for easily downloading CSO (Central Statistics
Office, the National Statistics Institute of Ireland) PxStat data into R.
}
\details{
A specific table can be downloaded using \code{\link{cso_get_data}},
while a list of all tables currently available and their titles can
be found using \code{\link{cso_get_toc}} and \code{\link{cso_search_toc}}
is used to search their descriptions.
Metadata for a specified table can be retrieved with
\code{\link{cso_get_meta}}, or printed on the console using
\code{\link{cso_disp_meta}}.

\code{\link{cso_get_vars}}, \code{\link{cso_get_interval}}, and
\code{\link{cso_get_content}} all return a subset of the full metadata of
a table. \code{\link{cso_get_var_values}} returns all the variables in the
tables.

These functions provide the option to cache the returned data using the
R.cache package. The cache can be deleted using
\code{\link{cso_clear_cache}}.

ESRI shapefiles covering the country in varying degrees of granularity can
be downloaded from
\href{https://www.cso.ie/en/census/census2011boundaryfiles/}{cso.ie} and
imported as an sf data frame using the \code{\link{cso_get_geo}} function.
Metadata about the map data can be retrieved with
\code{\link{cso_get_geo_meta}}, and displayed on the console with
\code{\link{cso_disp_geo_meta}}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/CSOIreland/csodata}
}

}
\author{
\strong{Maintainer}: Conor Crowley \email{conor.crowley@cso.ie}

Authors:
\itemize{
  \item Eoin Horgan \email{eoin.horgan@cso.ie} (\href{https://orcid.org/0000-0002-3446-6154}{ORCID})
  \item Vytas Vaiciulis \email{Vytas.Vaiciulis@cso.ie}
  \item Mervyn O'Luing \email{mervyn.oluing@cso.ie}
  \item James O'Rourke \email{james.orourke@cso.ie}
}

}
