% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{as.csv.data.frame}
\alias{as.csv.data.frame}
\title{Save a Data Frame as CSV.}
\usage{
\method{as.csv}{data.frame}(x, file, na = ".", quote = FALSE, auto = !quote, row.names = FALSE, ...)
}
\arguments{
\item{x}{data.frame}

\item{file}{passed to \code{\link{write.csv}}}

\item{na}{passed to \code{\link{write.csv}}}

\item{quote}{passed to \code{\link{write.csv}}}

\item{auto}{double-quote column names and row values with embedded commas or double-quotes; the latter are escaped by doubling them}

\item{row.names}{passed to \code{\link{write.csv}}}

\item{...}{passed to \code{\link{write.csv}} if accepted by \code{\link{write.table}}}
}
\value{
invisible data.frame (x)
}
\description{
Saves a data.frame as CSV, using selected conventions.
}
\examples{
x <- data.frame(
  check.names = FALSE,
  person = 1:3, 
  `name, suffix` = c("Bill Smith", 'Joseph "Joe" Hancock', "Mary Laguire, DDS")
)
file <- tempfile()
as.csv(x,file)
y <- as.csv(file,as.is=FALSE)
attr(y,'source')
attr(y,'source') <- NULL
x
y
stopifnot(identical(x,y))
}
\seealso{
Other as.csv: 
\code{\link{as.csv.character}()},
\code{\link{as.csv}()}
}
\concept{as.csv}
