% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_numTestArmsSubstances.R
\name{f.numTestArmsSubstances}
\alias{f.numTestArmsSubstances}
\title{Calculate type of control data collected in a study}
\usage{
f.numTestArmsSubstances(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.numTestArmsSubstances`, an integer
}
\description{
Trial concept calculated: number of active arms with different
investigational medicines, after excluding comparator, auxiliary and placebo
arms / medicines.
For ISRCTN, this is imprecise because arms are not identified in a field.
Most registers provide no or only limited information on phase 1 trials,
so that this number typically cannot be calculated for these trials.
Requires packages stringdist to be installed; stringdist is used for
evaluating names of active substances, which are considered similar when
the similarity is 0.8 or higher.
}
\examples{
# fields needed
f.controlType()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.numTestArmsSubstances",
  con = dbc)
trialsDf

}
