% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanTIpredeffects.R
\name{ctStanTIpredeffects}
\alias{ctStanTIpredeffects}
\title{Get time independent predictor effect estimates}
\usage{
ctStanTIpredeffects(fit, returndifference = FALSE, probs = c(0.025, 0.5,
  0.975), whichTIpreds = 1, whichpars = "all", plot = FALSE, ...)
}
\arguments{
\item{fit}{fit object from \code{\link{ctStanFit}}}

\item{returndifference}{logical. If FALSE, absolute parameter values are returned. 
If TRUE, only the effect of the covariate (i.e. without the average value of the parameter)
are returned. The former can be easier to interpret, but the latter are more likely to fit on 
a single plot.}

\item{probs}{numeric vector of quantile probabilities from 0 to 1. Specify 3
values if plotting, the 2nd will be drawn as a line with uncertainty polygon
based on 1st and 3rd.}

\item{whichTIpreds}{integer vector specifying which of the tipreds in the fit object you want to
use to calculate effects. Unless quadratic / higher order versions of predictors have been 
included, selecting more than one probably doesn't make sense. If for instance a squared
predictor has been included, then you can specify both the linear and squared version. 
The x axis of the plot (if generated) will be based off the first indexed predictor. To 
check what predictors are in the model, run \code{fit$ctstanmodel$TIpredNames}.}

\item{whichpars}{Integer vector specifying Which of the individually varying subject
level parameters to compute effects on. 
'auto' uses all available, which is equivalent to 
\code{1:sum(fit$ctstanmodel$pars$indvarying)}.
The integer corresponding to specific parameters can be found as follows, replacing \code{fit} as appropriate:
\code{fit$ctstanmodel$pars[sf$ctstanmodel$pars$indvarying,'param']}.}

\item{plot}{Logical. If TRUE, nothing is returned but instead \code{\link{ctPlotArray}}
is used to plot the output instead.}

\item{...}{arguments to pass to \code{\link{ctPlotArray}} for plotting.}
}
\value{
Either a three dimensional array of predictor effects, or nothing with a plot
generated.
}
\description{
COmputes and plots combined effects and quantiles for effects of time independent predictors
on subject level parameters of a ctStanFit object.
}
\examples{
ctStanTIpredeffects(ctstantestfit,plot=TRUE)
}
