% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctFit.R
\name{ctFit}
\alias{ctFit}
\title{Fit a ctsem object}
\usage{
ctFit(datawide, ctmodelobj, objective = "auto",
  stationary = c("T0TRAITEFFECT", "T0TIPREDEFFECT"), optimizer = "SLSQP",
  retryattempts = 15, iterationSummary = FALSE, carefulFit = TRUE,
  carefulFitWeight = 100, showInits = FALSE, asymptotes = FALSE,
  meanIntervals = FALSE, plotOptimization = F,
  crossEffectNegStarts = TRUE, nofit = FALSE, discreteTime = FALSE,
  verbose = 0, useOptimizer = TRUE, omxStartValues = NULL,
  transformedParams = TRUE)
}
\arguments{
\item{datawide}{the data you wish to fit a ctsem model to.}

\item{ctmodelobj}{the ctsem model object you wish to use, specified via the \code{\link{ctModel}} function.}

\item{objective}{'auto' selects either 'Kalman', if fitting to single subject data, 
or 'mxRAM' for multiple subjects. For single subject data, 'Kalman' uses the \code{mxExpectationStateSpace }
function from OpenMx to implement the Kalman filter. 
For more than one subject, 'mxRAM' specifies a wide format SEM with a row of data per subject.
'cov' may be specified, in which case the 'meanIntervals' argument is set to TRUE, and the covariance matrix
of the supplied data is calculated and fit instead of the raw data. This is much faster but only a rough approximation,
unless there are no individual differences in time interval and no missing data.
'Kalman' may be specified for multiple subjects, however as no trait matrices are used by the Kalman filter
one must consider how average level differences between subjects are accounted for.
See \code{\link{ctMultigroupFit}} for the possibility to apply the Kalman filter over multiple subjects)}

\item{stationary}{Character vector of T0 matrix names in which to constrain any 
free parameters to stationarity. 
Defaults to \code{c('T0TRAITEFFECT','T0TIPREDEFFECT')}, constraining only
between person effects to stationarity. Use \code{NULL} for no constraints,
or 'all' to constrain all T0 matrices.}

\item{optimizer}{character string, defaults to the open-source 'SLSQP' optimizer that is distributed
in all versions of OpenMx. However, 'NPSOL' may sometimes perform better for these problems,
though requires that you have installed OpenMx via the OpenMx web site, by running:
\code{source('http://openmx.psyc.virginia.edu/getOpenMx.R')}}

\item{retryattempts}{Number of times to retry the start value randomisation and fit procedure, if non-convergance or uncertain fits occur.}

\item{iterationSummary}{if TRUE, outputs limited fit details after every fit attempt.}

\item{carefulFit}{if TRUE, first fits the specified model with a penalised likelihood function 
to force MANIFESTVAR, DRIFT, TRAITVAR, MANIFESTTRAITVAR parameters to remain close to 0, then
fits the specified model normally, using these estimates as starting values. 
Can help to ensure optimization begins at sensible, non-exteme values, 
though results in any user specified start values being ignored for the final fit (though they are still used for initial fit).}

\item{carefulFitWeight}{Positive numeric. Sets the weight for the penalisation (or prior) applied by the carefulFit algorithm. 
Generally unnecessary to adjust, may be helpful to try a selection of values (perhaps between 0 and 1000) when optimization is problematic.}

\item{showInits}{if TRUE, prints the list of 
starting values for free parameters. These are the 'raw' values used by OpenMx, 
and reflect the log (var / cov matrices) or -log(DRIFT matrices) transformations used in ctsem.
These are saved in the fit object under \code{fitobject$omxStartValues}.}

\item{asymptotes}{when TRUE, optimizes over asymptotic parameter matrices instead of continuous time parameter matrices. 
Can be faster for optimization and in some cases makes reliable convergance easier. Will result in equivalent models 
when continuous time input matrices (DRIFT, DIFFUSION, CINT) are free, but fixing the values of 
any such matrices will result in large differences - a value of 0 in a cell of the normal continuous time DIFFUSION matrix
does not necessarily result in a value of 0 for the asymptotic DIFFUSION matrix, for instance.}

\item{meanIntervals}{Use average time intervals for each column for calculation 
(both faster and inaccurate to the extent that intervals vary across individuals).}

\item{plotOptimization}{If TRUE, uses checkpointing for OpenMx function \code{mxRun}, set to checkpoint every iteration, 
output checkpoint file to working directory, then creates a plot for each parameter's values over iterations.}

\item{crossEffectNegStarts}{Logical. If TRUE (default) free DRIFT matrix cross effect parameters have starting values 
set to small negative values (e.g. -.05), if FALSE, the start values are 0. The TRUE setting is useful for easy 
initialisation of higher order models, while the FALSE setting is useful when one has already estimated a model without cross effects,
and wishes to begin optimization from those values by using the omxStartValues switch.
are re-transformed into regular continuous time parameter matrices, and may be interpreted as normal.}

\item{nofit}{if TRUE, output only openmx model without fitting}

\item{discreteTime}{Estimate a discrete time model - ignores timing information, parameter
estimates will correspond to those of classical vector autoregression models, 
OpenMx fit object will be directly output, thus ctsem summary and plot functionality will be unavailable.
Time dependent predictor type also becomes irrelevant.}

\item{verbose}{Integer between 0 and 3. Sets mxComputeGradientDescent messaging level, defaults to 0.}

\item{useOptimizer}{Logical. Defaults to TRUE.  Passes argument to \code{mxRun}, 
useful for using custom optimizers or fitting to specified parameters.}

\item{omxStartValues}{A named vector containing the raw (potentially log transformed) OpenMx starting values for free parameters, as captured by
OpenMx function \code{omxGetParameters(ctmodelobj$mxobj)}. These values will take precedence 
over any starting values already specified using ctModel.}

\item{transformedParams}{Logical indicating whether or not to log transform 
certain parameters internally to allow unconstrained estimation over
entire 'sensible' range for parameters. 
When TRUE (default) raw OpenMx parameters (only reported if \code{verbose=TRUE} argument used
for summary function) will reflect these transformations and may be harder to 
interpret, but summary matrices are reported as normal.}
}
\description{
This function fits continuous time SEM models specified via \code{\link{ctModel}}
to a dataset containing one or more subjects.
}
\details{
For full discussion of how to structure the data and use this function, see the vignette using: \code{vignette('ctsem')}.
Models are specified using the \code{\link{ctModel}} function.
For help regarding the summary function, see \code{\link{summary.ctsemFit}}, 
and for the plot function, \code{\link{plot.ctsemFit}}.
Multigroup models may be specified using \code{\link{ctMultigroupFit}}.
Confidence intervals for any matrices and or parameters 
may be estimated using \code{\link{ctCI}}.
}
\examples{
## Examples set to 'dontrun' because they take longer than 5s.
\dontrun{
mfrowOld<-par()$mfrow
par(mfrow=c(2, 3))

### example from Driver, Oud, Voelkle (2017), 
### simulated happiness and leisure time with unobserved heterogeneity.
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2), 
  manifestNames=c('LeisureTime', 'Happiness'), 
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(datawide=ctExample1, ctmodelobj=traitmodel)
summary(traitfit)
plot(traitfit, wait=FALSE)


###Example from Voelkle, Oud, Davidov, and Schmidt (2012) - anomia and authoritarianism.  
data(AnomAuth) 
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2), 
Tpoints = 5, n.latent = 2, n.manifest = 2, MANIFESTVAR=diag(0, 2), TRAITVAR = NULL) 
AnomAuthfit <- ctFit(AnomAuth, AnomAuthmodel)
summary(AnomAuthfit)


### Single subject time series - using Kalman filter (OpenMx statespace expectation)
data('ctExample3')
model <- ctModel(n.latent = 1, n.manifest = 3, Tpoints = 100, 
  LAMBDA = matrix(c(1, 'lambda2', 'lambda3'), nrow = 3, ncol = 1), 
  MANIFESTMEANS = matrix(c(0, 'manifestmean2', 'manifestmean3'), nrow = 3, 
    ncol = 1))
fit <- ctFit(data = ctExample3, ctmodelobj = model, objective = 'Kalman', 
  stationary = c('T0VAR'))


###Oscillating model from Voelkle & Oud (2013). 
data("Oscillating")

inits <- c(-39, -.3, 1.01, 10.01, .1, 10.01, 0.05, .9, 0)
names(inits) <- c("crosseffect","autoeffect", "diffusion",
  "T0var11", "T0var21", "T0var22","m1", "m2", 'manifestmean')

oscillatingm <- ctModel(n.latent = 2, n.manifest = 1, Tpoints = 11,
  MANIFESTVAR = matrix(c(0), nrow = 1, ncol = 1),
  LAMBDA = matrix(c(1, 0), nrow = 1, ncol = 2),
  T0MEANS = matrix(c('m1', 'm2'), nrow = 2, ncol = 1),
  T0VAR = matrix(c("T0var11", "T0var21", 0, "T0var22"), nrow = 2, ncol = 2),
  DRIFT = matrix(c(0, "crosseffect", 1, "autoeffect"), nrow = 2, ncol = 2),
  CINT = matrix(0, ncol = 1, nrow = 2),
  MANIFESTMEANS = matrix('manifestmean', nrow = 1, ncol = 1),
  DIFFUSION = matrix(c(0, 0, 0, "diffusion"), nrow = 2, ncol = 2),
  startValues=inits)

oscillatingf <- ctFit(Oscillating, oscillatingm, carefulFit = FALSE)
}
}
