% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanPlotPost.R
\name{ctStanPlotPost}
\alias{ctStanPlotPost}
\title{ctStanPlotPost}
\usage{
ctStanPlotPost(obj, rows = "all", priorwidth = TRUE, mfrow = "auto",
  lwd = 2, smoothness = 1, parcontrol = list(mgp = c(1.3, 0.5, 0),
  mar = c(3, 2, 2, 1) + 0.2), wait = FALSE)
}
\arguments{
\item{obj}{fit or model object as generated by \code{\link{ctStanFit}},
\code{\link{ctModel}}, or \code{\link{ctStanModel}}.}

\item{rows}{vector of integers denoting which rows of obj$setup$popsetup to plot priors for. 
Character string 'all' plots all rows with parameters to be estimated.}

\item{priorwidth}{if TRUE, plots will be scaled to show bulk of both the prior 
and posterior distributions. If FALSE, scale is based only on the posterior.}

\item{mfrow}{2 dimensional integer vector defining number of rows and columns of plots,
as per the mfrow argument to \code{\link[graphics]{par}}.
'auto' determines automatically, to a maximum of 4 by 4, while \code{NULL} 
uses the current system setting.}

\item{lwd}{line width for plotting.}

\item{smoothness}{Positive numeric -- multiplier to modify smoothness of density plots, higher is smoother but
can cause plots to exceed natural boundaries, such as standard deviations below zero.}

\item{parcontrol}{parameters to pass to \code{\link[graphics]{par}} which temporarily
change plot settings.}

\item{wait}{If true, user is prompted to continue before plotting next graph.
If false, graphs are plotted one after another without waiting.}
}
\description{
Plots prior and posterior distributions of model parameters in a ctStanModel or ctStanFit object.
}
\examples{
ctStanPlotPost(ctstantestfit, rows=3:4)
}
