% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_envelope.R
\encoding{UTF-8}
\name{spectral_envelope}
\alias{spectral_envelope}
\title{Computes the spectral envelope of a categorical time series}
\usage{
spectral_envelope(binarized_series, plot = TRUE)
}
\arguments{
\item{binarized_series}{A CTS in binarized form.}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns a plot of the
spectral envelope. Otherwise, returns the values of the spectral envelope
at each frequency and the corresponding set of optimal scalings}
}
\value{
If \code{plot = TRUE} (default), returns returns a plot of the spectral envelope. Otherwise, the function
returns the values of the spectral envelope  at each frequency and the corresponding set
of optimal scalings
}
\description{
\code{spectral_envelope} computes the spectral envelope
a categorical time series
}
\details{
The function represents the spectral envelope of a categorical time series
}
\examples{
binarized_series <- binarization(GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')))
se <- spectral_envelope(binarized_series = binarized_series) # Representing the spectral envelope
# for the first series in dataset GeneticSequences
spectral_quantities <- spectral_envelope(binarized_series = binarized_series,
plot = FALSE) # Computing the corresponding
# spectral quantities
}
\references{
{

  \insertRef{stoffer1993spectral}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
