% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarization.R
\encoding{UTF-8}
\name{binarization}
\alias{binarization}
\title{Constructs the binarized time series associated with a given
categorical time series}
\usage{
binarization(series, categories)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}
}
\value{
The binarized time series.
}
\description{
\code{binarization} constructs the binarized time series associated with a given
categorical time series.
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function
constructs the binarized time series, which is defined as
\eqn{\overline{\boldsymbol Y}_t=\{\overline{\boldsymbol Y}_1, \ldots, \overline{\boldsymbol Y}_T\}},
with \eqn{\overline{\boldsymbol Y}_k=(\overline{Y}_{k,1}, \ldots, \overline{Y}_{k,r})^\top}
such that \eqn{\overline{Y}_{k,i}=1} if \eqn{\overline{X}_k=i} (\eqn{k=1,\ldots,T,
, i=1,\ldots,r}). The binarized series is constructed in the form of a matrix
whose rows represent time observations and whose columns represent the
categories in the original series
}
\examples{
binarized_series <- binarization(GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Constructing the binarized
# time series for the first CTS in dataset GeneticSequences
}
\references{
{

  \insertRef{lopez2023hard}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
