% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_general_exposure_prediction}
\alias{get_general_exposure_prediction}
\title{Get general exposure prediction data}
\usage{
get_general_exposure_prediction(
  DTXSID = NULL,
  API_key = NULL,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.table of general exposure prediction data or NULL if data is
missing.
}
\description{
Get general exposure prediction data
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull general exposure prediction data for BPA
bpa <- get_general_exposure_prediction(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
