% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsx.R
\name{bsx}
\alias{bsx}
\title{Polynomial B-splines with eXtensions}
\usage{
bsx(x, df = NULL, knots = NULL, degree = 3, intercept = FALSE,
  Boundary.knots = range(x), deriv = NULL)
}
\arguments{
\item{x}{the predictor variable. Missing values are allowed.}

\item{df}{degrees of freedom; one can specify \code{df} rather than knots; \code{bs()} then chooses
\code{df}-\code{degree} (minus one if there is an intercept) knots at suitable quantiles of \code{x}
(which will ignore missing values). The default, \code{NULL}, corresponds to no inner knots,
i.e., \code{degree}-\code{intercept}.}

\item{knots}{the internal breakpoints that define the spline. The default is \code{NULL}, which results
in a basis for ordinary polynomial regression. Typical values are the mean or median for one knot,
quantiles for more knots. See also \code{Boundary.knots}.}

\item{degree}{degree of the piecewise polynomial—default is \code{3} for cubic splines.}

\item{intercept}{if \code{TRUE}, an intercept is included in the basis; default is \code{FALSE}.}

\item{Boundary.knots}{boundary points at which to anchor the B-spline basis (default the range of the non-NA data).
If both \code{knots} and \code{Boundary.knots} are supplied, the basis parameters do not depend on \code{x}.
Data can extend beyond \code{Boundary.knots}.}

\item{deriv}{an integer vector of length 2 with values between 0 and \code{degree + 1} giving the
derivative constraint order at the left and right boundary knots;
an order of 2 constrains the second derivative to zero (f”(x)=0);
an order of 1 constrains the first and second derivatives to zero (f'(x)=f”(x)=0);
an order of 0 constrains the zero, first and second derivatives to zero (f(x)=f'(x)=f”(x)=0)
An order of \code{degree + 1} computes the basis matrix similarly to \code{bs}.}
}
\value{
A matrix with containing the basis functions evaluated in \code{x}.
}
\description{
Generate the B-spline basis matrix for a polynomial spline with derivative restrictions at the boundary knots.
}
