% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_tai}
\alias{get_tai}
\title{Calculate TAI}
\usage{
get_tai(cf, trna_w)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by \code{count_codons()}.}

\item{trna_w}{tRNA weight for each codon, can be generated with \code{est_trna_weight()}.}
}
\value{
a named vector of TAI values
}
\description{
\code{get_tai} calculates tRNA Adaptation Index (TAI) of each CDS
}
\examples{
# calculate TAI of yeast genes based on genomic tRNA copy numbers
w <- est_trna_weight(yeast_trna_gcn)
cf_all <- count_codons(yeast_cds)
tai <- get_tai(cf_all, w)
head(tai)
hist(tai)

}
\references{
dos Reis M, Savva R, Wernisch L. 2004. Solving the riddle of codon usage
  preferences: a test for translational selection. Nucleic Acids Res 32:5036-5044.
}
