% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{match_sites}
\alias{match_sites}
\alias{match_spatial}
\alias{match_postprocessing}
\alias{match_temporal}
\title{Matching sites from two data sources}
\usage{
match_sites(
  major,
  minor,
  spatial_single_match = TRUE,
  spatial_n_keep = 1,
  spatial_dist_max = 10,
  temporal_matching = TRUE,
  temporal_by,
  temporal_n_highest = 20,
  temporal_independent,
  temporal_window = 5,
  temporal_min_match = 10
)

match_spatial(
  major,
  minor,
  spatial_single_match = TRUE,
  spatial_n_keep = 1,
  spatial_dist_max = 10
)

match_postprocessing(major, minor, match_table)

match_temporal(
  major,
  minor,
  temporal_by,
  temporal_n_highest = 20,
  temporal_independent,
  temporal_window = 5,
  temporal_min_match = 10
)
}
\arguments{
\item{major}{The major dataset to match, every key in the major dataset will have a match, unless filtered by \code{dist_max}}

\item{minor}{The dataset to match from}

\item{spatial_single_match}{Whether each observation in the minor dataset is only allowed to to be matched once, default to \code{TRUE}}

\item{spatial_n_keep}{The number of matching to keep}

\item{spatial_dist_max}{The maximum distance allowed between matched pair}

\item{temporal_matching}{Whether to perform temporal matching}

\item{temporal_by}{The variable used for temporal matching}

\item{temporal_n_highest}{The number of highest peak used for temporal matching}

\item{temporal_independent}{The dataset used to construct the temporal window,
need to be the name of either major or minor.}

\item{temporal_window}{The temporal window allowed to fall in}

\item{temporal_min_match}{The minimum number of peak matching for temporal matching}

\item{match_table}{The spatial matching table}
}
\value{
A cubble with matched pairs
}
\description{
The function includes both spatial and temporal matching. The spatial matching
is based on the distance and the distance is calculated using the Vincenty
formula assuming earth is sphere with a radius of 6371 km. The temporal matching
first filters out the \code{n} largest increases, determined by \code{temporal_n_highest},
in both datasets,  constructs an interval of length \code{temporal_window} from
one dataset and count the number that large increase from the other dataset
falls into the interval constructed.
}
