% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dist.images}
\alias{dist.images}
\title{Distance for images}
\usage{
dist.images(images, verbosity = 0L)
}
\arguments{
\item{images}{A 3-dimensional array with each slice (matrix in first two
dimensions) corresponding to an image. Each (eps-strictly) positive
entry is regarded as an occupied pixel (one), otherwise it is regarded
as an empty pixel, of an image.}

\item{verbosity}{Level of reporting messages, the higher the more progress
reports are printed, set \code{0} (default) for no messages.}
}
\value{
A matrix \code{dim(images)[3] x dim(images)[3]} with each entry
being the distance between two images.
}
\description{
Calculates distance matrix for a sample of images using the minimax metric.
This fucntion can be seen as a wrapper of a sequential call of
\code{images2curves} and \code{dist.curves}.
}
\examples{
library(curveDepth)
# Pixel-grid filling function for an image
plotGridImage <- function(dims){
  redDims1 <- dims[1] - 1
  redDims2 <- dims[2] - 1
  for (i in 1:(dims[1] - 1)){
    lines(c(i / redDims1 - 0.5 / redDims1,
            i / redDims1 - 0.5 / redDims1),
          c(0 - 0.5 / redDims2, 1 + 0.5 / redDims2),
          lwd = 1, lty = 3, col = "lightgray")
    lines(c(0 - 0.5 / redDims1, 1 + 0.5 / redDims1),
          c(i / redDims2 - 0.5 / redDims2,
            i / redDims2 - 0.5 / redDims2),
          lwd = 1, lty = 3, col = "lightgray")
  }
  rect(0 - 0.5 / redDims1, 0 - 0.5 / redDims2,
       1 + 0.5 / redDims1, 1 + 0.5 / redDims2)
}
# Load two Sevens and one One, and plot them
data("mnistShort017")
# First Seven
  firstSevenDigit <- mnistShort017$`7`[, , 5]
image(as.matrix(rev(as.data.frame(firstSevenDigit))),
      col = gray((255:0) / 256), asp = 1,
      xlim = c(0 - 1 / 27, 1 + 1 / 27),
      ylim = c(0 - 1 / 27, 1 + 1 / 27))
plotGridImage(dim(firstSevenDigit)[1:2])
# Second Seven
secondSevenDigit <- mnistShort017$`7`[, , 6]
image(as.matrix(rev(as.data.frame(secondSevenDigit))),
      col = gray((255:0) / 256), asp = 1,
      xlim = c(0 - 1 / 27, 1 + 1 / 27),
      ylim = c(0 - 1 / 27, 1 + 1 / 27))
plotGridImage(dim(secondSevenDigit)[1:2])
# A One
aOneDigit <- mnistShort017$`1`[, , 1]
image(as.matrix(rev(as.data.frame(aOneDigit))),
      col = gray((255:0) / 256), asp = 1,
      xlim = c(0 - 1 / 27, 1 + 1 / 27),
      ylim = c(0 - 1 / 27, 1 + 1 / 27))
plotGridImage(dim(aOneDigit)[1:2])
# Caculate distances between all the images
distMatrix <- dist.images(
  abind(firstSevenDigit, secondSevenDigit, aOneDigit,
        along = 3))
# Print distance matrix
print(distMatrix)
}
\references{
Lafaye De Micheaux, P., Mozharovskyi, P. and Vimond, M. (2018).
Depth for curve data and applications.
}
