% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{misclassification_cost}
\alias{misclassification_cost}
\title{Calculate the misclassification cost}
\usage{
misclassification_cost(tp, fp, tn, fn, cost_fp = 1, cost_fn = 1, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{cost_fp}{(numeric) the cost of a false positive}

\item{cost_fn}{(numeric) the cost of a false negative}

\item{...}{for capturing additional arguments passed by method.}
}
\description{
Calculate the misclassification cost from
true positives, false positives, true negatives and false negatives.
The inputs must be vectors of equal length. \cr \cr
misclassification_cost = cost_fp * fp + cost_fn * fn \cr
}
\examples{
misclassification_cost(10, 5, 20, 10, cost_fp = 1, cost_fn = 5)
misclassification_cost(c(10, 8), c(5, 7), c(20, 12), c(10, 18),
                       cost_fp = 1, cost_fn = 5)
}
\seealso{
Other metric functions: 
\code{\link{F1_score}()},
\code{\link{Jaccard}()},
\code{\link{abs_d_ppv_npv}()},
\code{\link{abs_d_sens_spec}()},
\code{\link{accuracy}()},
\code{\link{cohens_kappa}()},
\code{\link{cutpoint}()},
\code{\link{false_omission_rate}()},
\code{\link{metric_constrain}()},
\code{\link{npv}()},
\code{\link{odds_ratio}()},
\code{\link{p_chisquared}()},
\code{\link{plr}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{prod_ppv_npv}()},
\code{\link{prod_sens_spec}()},
\code{\link{recall}()},
\code{\link{risk_ratio}()},
\code{\link{roc01}()},
\code{\link{sensitivity}()},
\code{\link{specificity}()},
\code{\link{sum_ppv_npv}()},
\code{\link{sum_sens_spec}()},
\code{\link{total_utility}()},
\code{\link{tpr}()},
\code{\link{tp}()},
\code{\link{youden}()}
}
\concept{metric functions}
