% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldFunctions.R
\name{cvScaledMatrixFrobeniusLoss}
\alias{cvScaledMatrixFrobeniusLoss}
\title{Cross-Validation Function for Scaled Matrix Frobenius Loss}
\usage{
cvScaledMatrixFrobeniusLoss(fold, dat, estimator_funs, estimator_params = NULL)
}
\arguments{
\item{fold}{A \code{fold} object (from \code{\link[origami]{make_folds}()})
over which the estimation procedure is to be performed.}

\item{dat}{A \code{data.frame} containing the full (non-sample-split) data,
on which the cross-validated procedure is performed.}

\item{estimator_funs}{An \code{expression} corresponding to a vector of
covariance matrix estimator functions to be applied to the training data.}

\item{estimator_params}{A named \code{list} of arguments corresponding to
the hyperparameters of covariance matrix estimators, \code{estimator_funs}.
The name of each list element should be the name of an estimator passed to
\code{estimator_funs}. Each element of the \code{estimator_params} is
itself a named \code{list}, with names corresponding to an estimators'
hyperparameter(s). These hyperparameters may be in the form of a single
\code{numeric} or a \code{numeric} vector. If no hyperparameter is needed
for a given estimator, then the estimator need not be listed.}
}
\value{
A \code{\link[tibble]{tibble}} providing information on estimators,
their hyperparameters (if any), and their scaled matrix Frobenius loss
evaluated on a given \code{fold}.
}
\description{
\code{cvScaledMatrixFrobeniusLoss()} evaluates the scaled matrix
Frobenius loss over a \code{fold} object (from '\pkg{origami}'
\insertCite{Coyle2018}{cvCovEst}). The squared error loss computed for each
entry of the estimated covariance matrix is scaled by the training set's
sample variances of the variable associated with that entry's row and
column variables. This loss should be used instead of
\code{\link{cvMatrixFrobeniusLoss}()} when a dataset's variables' values
are of different magnitudes.
}
\examples{
library(MASS)
library(origami)
library(rlang)

# generate 10x10 covariance matrix with unit variances and off-diagonal
# elements equal to 0.5
Sigma <- matrix(0.5, nrow = 10, ncol = 10) + diag(0.5, nrow = 10)

# sample 50 observations from multivariate normal with mean = 0, var = Sigma
dat <- mvrnorm(n = 50, mu = rep(0, 10), Sigma = Sigma)

# generate a single fold using MC-cv
resub <- make_folds(dat,
  fold_fun = folds_vfold,
  V = 2
)[[1]]
cvScaledMatrixFrobeniusLoss(
  fold = resub,
  dat = dat,
  estimator_funs = rlang::quo(c(
    linearShrinkEst, thresholdingEst, sampleCovEst
  )),
  estimator_params = list(
    linearShrinkEst = list(alpha = c(0, 1)),
    thresholdingEst = list(gamma = c(0, 1))
  )
)
}
\references{
\insertAllCited{}
}
