% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.cvCovEst}
\alias{summary.cvCovEst}
\title{Generic Summary Method for cvCovEst}
\usage{
\method{summary}{cvCovEst}(
  object,
  dat_orig,
  summ_fun = c("cvRiskByClass", "bestInClass", "worstInClass", "hyperRisk"),
  ...
)
}
\arguments{
\item{object}{A named \code{list} of class \code{"cvCovEst"}.}

\item{dat_orig}{The \code{numeric data.frame}, \code{matrix}, or similar
object originally passed to \code{\link{cvCovEst}()}.}

\item{summ_fun}{A \code{character} vector specifying which summaries to
output.  See Details for function descriptions.}

\item{...}{Additional arguments passed to \code{summary()}These are not
explicitly used and should be ignored by the user.}
}
\value{
A named \code{list} where each element corresponds to the output of
of the requested summaries.
}
\description{
\code{summary()} provides summary statistics regarding
the performance of \code{\link{cvCovEst}()} and can be used for diagnostic
plotting.
}
\details{
\code{summary()} accepts four different choices for the
\code{summ_fun} argument.  The choices are:
\itemize{
\item \code{"cvRiskByClass"} - Returns the minimum, first quartile,
median, third quartile, and maximum of the cross-validated risk
associated with each class of estimator passed to
\code{\link{cvCovEst}()}.
\item \code{"bestInClass"} - Returns the specific hyperparameters, if
applicable, of the best performing estimator within each class along
with other metrics.
\item \code{"worstInClass"} - Returns the specific hyperparameters, if
applicable, of the worst performing estimator within each class along
with other metrics.
\item \code{"hyperRisk"} - For estimators that take hyperparameters as
arguments, this function returns the hyperparameters associated with
the minimum, first quartile, median, third quartile, and maximum of the
cross-validated risk within each class of estimator. Each class has
its own \code{\link[tibble]{tibble}}, which are returned as a
\code{list}.
}
}
\examples{
cv_dat <- cvCovEst(
  dat = mtcars,
  estimators = c(
    linearShrinkEst, thresholdingEst, sampleCovEst
  ),
  estimator_params = list(
    linearShrinkEst = list(alpha = seq(0.1, 0.9, 0.1)),
    thresholdingEst = list(gamma = seq(0.1, 0.9, 0.1))
  ),
  center = TRUE,
  scale = TRUE
)

summary(cv_dat, mtcars)
}
