% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CalibrationSet.R
\name{CalibrationSet}
\alias{CalibrationSet}
\title{Create a CalibrationSet object}
\usage{
CalibrationSet(scenario, data, weight = 1)
}
\arguments{
\item{scenario}{any kind of \code{EffectScenario} or \code{\link[=sequence]{sequence()}}.}

\item{data}{a \code{data.frame} with effect data in long format containing two
columns: the 1st column with \code{numeric} time points and 2nd column with
\code{numeric} effect data to fit to.}

\item{weight}{optional \code{numeric} weight to be applied to this datasets' error
term during fitting, default values is 1.}
}
\value{
\code{CalibrationSet()} returns a \code{CalibrationSet} object with three
slots containing \code{scenario}, \code{data}, and \code{weight}. Warnings are returned
when input data are not a \code{data.frame} with 2 columns\code{.}
}
\description{
\code{CalibrationSet()} creates an object of the \code{CalibrationSet}
class, which combines an \code{EffectScenario} and the corresponding effect data
into one object. The created \code{CalibrationSet} object can subsequently be
used for calibration of a model.

Instead of an \code{EffectScenario}, a \code{sequence} can also be used,
e.g., when during an experiment a change in conditions is created which
should not be captured by the model (e.g., a pump failure, a sudden change
in temperature, or the removal of some experimental organisms from the
system to avoid overcrowding, see \code{\link[=sequence]{sequence()}}).

Optionally, a weight can be added to the \code{CalibrationSet}, in case one
\code{CalibrationSet} should have more weight in the subsequent model
calibration compared to other \code{CalibrationSets}.
}
\examples{
# Lemna example with `EffectScenario` ----------------------------------------------
# 1st get effect data
eff_df <- Schmitt2013 \%>\%
  dplyr::filter(ID == "T0") \%>\%
  dplyr::select(t, obs)
# 2nd, create `CalibrationSet`
Cal_set <- CalibrationSet(scenario = metsulfuron, data = eff_df)
# optionally, add a weight to the data
Cal_set2 <- CalibrationSet(scenario = metsulfuron, data = eff_df, weight = 4)
# look at what is returned
Cal_set@data
Cal_set@scenario
Cal_set@scenario@name
Cal_set@weight

# Lemna example with `sequence` ----------------------------------------------
# Let's change the end of the exposure scenario in the `metsulfuron` `EffectScenario`
metsulfuron@exposure
altered_exposure_end <- data.frame(
  time = c(5:10),
  c = rep(1.5, 6)
)
metsulfuron \%>\%
  set_times(c(0:4)) -> metsulfuron_1sthalf
metsulfuron \%>\%
  set_exposure(altered_exposure_end) \%>\%
  set_times(c(5:10)) -> metsulfuron_2ndhalf
# then, create a scenario sequence
Sequence <- sequence(
  c(metsulfuron_1sthalf, metsulfuron_2ndhalf)
)
# finally, create a `CalibrationSet` with the sequence
obs32 <- Schmitt2013 \%>\%
  dplyr::filter(ID == "T0.32") \%>\%
  dplyr::select(t, obs)
Cal_set3 <- CalibrationSet(Sequence, obs32)
# look at what is returned
Cal_set3@scenario@scenarios[[1]]

}
