% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-lemna_setac.R
\name{Lemna_SETAC}
\alias{Lemna_SETAC}
\alias{LemnaSetacScenario-class}
\alias{LemnaSetac-class}
\title{Lemna model (Klein et al. 2021)}
\usage{
Lemna_SETAC()
}
\value{
an S4 object of type \linkS4class{LemnaSetac}
}
\description{
The model was described and published by the SETAC Europe Interest Group
Effect Modeling (Klein et al. 2022). It is based on the \emph{Lemna} model
by Schmitt (2013). The model is a mechanistic combined
toxicokinetic-toxicodynamic (TK/TD) and growth model for the aquatic
macrophytes \emph{Lemna spp.}. The model simulates the development of Lemna biomass
under laboratory and environmental conditions. Growth of the Lemna population
is simulated on basis of photosynthesis and respiration rates which are
functions of environmental conditions. The toxicodynamic sub-model describes
the effects of growth-inhibiting substances by a respective reduction in the
photosynthesis rate based on internal concentrations.
}
\section{State variables}{

The model has two state variables:
\itemize{
\item \code{BM}, Biomass (g dw m-2)
\item \code{M_int}, Mass of toxicant in plant population (mass per m2, e.g. ug m-2)
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{k_photo_fixed}, Model switch for unlimited growth conditions (TRUE/FALSE)
\item \code{k_photo_max}, Maximum photosynthesis rate (d-1)
\item \code{k_loss}, Reference loss rate (d-1)
\item \code{BM_threshold}, Lower biomass abundance threshold,  (g dw m-2)
\item \code{BM_min}, Reservoir for biomass recovery,  (g dw m-2)
}
\item Temperature response of photosynthesis
\itemize{
\item \code{T_opt}, Optimum growth temperature (°C)
\item \code{T_min}, Minimum growth temperature (°C)
\item \code{T_max}, Maximum growth temperature (°C)
}
\item Temperature response of biomass loss rate
\itemize{
\item \code{Q10}, Temperature coefficient (-)
\item \code{T_ref}, Reference temperature for response=1 (°C)
}
\item Irradiance reponse of photosynthesis
\itemize{
\item \code{alpha}, Slope of irradiance response (m2 d kJ-1)
\item \code{beta}, Intercept of irradiance response (-)
}
\item Nutrient response of photosynthesis
\itemize{
\item \code{N_50}, Half-saturation constant of Nitrogen (mg N L-1)
\item \code{P_50}, Half-saturation constant of Phosphorus (mg P L-1)
}
\item Density dependence of photosynthesis
\itemize{
\item \code{BM_L}, Carrying capacity (g dw m-2)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC50_int}, Internal concentration resulting in 50\% effect (ug L-1)
\item \code{E_max}, Maximum inhibition (-)
\item \code{b}, Slope parameter (-)
}
\item Internal concentration (Toxicokinetics)
\itemize{
\item \code{P}, Permeability (cm d-1)
\item \code{r_A_DW}, Area per dry-weight ratio (cm2 g-1)
\item \code{r_FW_DW}, Fresh weight per dry weight ratio (-)
\item \code{r_FW_V}, Fresh weight density (g cm-3)
\item \code{r_DW_FN}, Dry weight per frond ratio  (g dw)
\item \code{K_pw}, Partitioning coefficient plant:water (-)
\item \code{k_met}, Metabolisation rate (d-1)
}
}
}

\section{Forcings}{

Besides exposure, the model requires four environmental properties as
time-series input:
\itemize{
\item \code{tmp}, temperature (°C)
\item \code{irr}, irradiance (kJ m-2 d-1)
\item \code{P}, Phosphorus concentration (mg P L-1)
\item \code{N}, Nitrogen concentration (mg N L-1)
}

Forcings time-series are represented by \code{data.frame} objects consisting of two
columns. The first for time and the second for the environmental factor in question.

Entries of the \code{data.frame} need to be ordered chronologically. A time-series
can consist of only a single row; in this case it will represent constant
environmental conditions. See \link{scenarios} for more details.
}

\section{Effects}{

Supported effect endpoints include \emph{BM} (biomass) and \emph{r} (average
growth rate during simulation). The effect on biomass is calculated from
the last state of a simulation. Be aware that endpoint \emph{r} is incompatible
with biomass transfers.
}

\section{Simulation output}{

For reasons of convenience, the return value contains by default two additional
variables derived from simulation results: the internal concentration \code{C_int}
as well as the number of fronds \code{FrondNo}. These can be disabled by setting
the argument \code{nout = 0}.

The available output levels are as follows:
\itemize{
\item \code{nout >= 1}: \code{C_int}, internal concentration (mass per volume)
\item \code{nout >= 2}: \code{FrondNo}, frond number (-)
\item Response functions
\itemize{
\item \code{nout >= 3}: \code{f_loss}, respiration dependency function (-)
\item \code{nout >= 4}: \code{f_photo}, photosynthesis dependency function (-)
\item \code{nout >= 5}: \code{fT_photo}, temperature response of photosynthesis (-)
\item \code{nout >= 6}: \code{fI_photo}, irradiance response of photosynthesis (-)
\item \code{nout >= 7}: \code{fP_photo}, phosphorus response of photosynthesis (-)
\item \code{nout >= 8}: \code{fN_photo}, nitrogen response of photosynthesis (-)
\item \code{nout >= 9}: \code{fBM_photo}, density response of photosynthesis (-)
\item \code{nout >= 10}: \code{fCint_photo}, concentration response of photosynthesis (-)
}
\item Environmental variables
\itemize{
\item \code{nout >= 11}: \code{C_int_unb}, unbound internal concentration (mass per volume)
\item \code{nout >= 12}: \code{C_ext}, external concentration (mass per volume)
\item \code{nout >= 13}: \code{Tmp}, temperature (deg C)
\item \code{nout >= 14}: \code{Irr}, irradiance (kJ m-2 d-1)
\item \code{nout >= 15}: \code{Phs}, Phosphorus concentration (mg P L-1)
\item \code{nout >= 16}: \code{Ntr}, Nitrogen concentration (mg N L-1)
}
\item Derivatives
\itemize{
\item \code{nout >= 17}: \code{dBM}, biomass derivative (g dw m-2 d-1)
\item \code{nout >= 18}: \code{dM_int}, mass of toxicant in plants derivative (mass per m2 d-1)
}
}
}

\section{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.

Some default settings of \emph{deSolve} were adapted for this model by expert
judgement to enable precise, but also computationally efficient, simulations
for most model parameters. These settings can be modified by the user,
if needed:
\itemize{
\item \code{hmax = 0.1}\if{html}{\out{<br>}}
Maximum step length in time suitable for most simulations.
}
}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. \emph{Lemna} effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

If a transfer occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that if transfers are defined using the
\code{interval} argument, the transfers will always occur relative to time point
zero (\code{t = 0}). As an example, setting a regular transfer of seven days,
\code{interval =  7}, will result at transfers occurring at time points which are
integer multiplicates of seven, such as \code{t=0}, \code{t=7}, \code{t=14} and so forth.
The starting and end times of a scenario do not influece \strong{when} a regular
transfer occurs, only \strong{if} it occurs.
}

\references{
Klein J., Cedergreen N., Heine S., Reichenberger S., Rendal C.,
Schmitt W., Hommen U., 2021: \emph{Refined description of the Lemna TKTD growth model
based on Schmitt et al. (2013) - equation system and default parameters}.
Report of the working group \emph{Lemna} of the SETAC Europe Interest Group Effect
Modeling. Version 1, uploaded on 22. Sept. 2021.
https://www.setac.org/group/effect-modeling.html

Schmitt W., Bruns E., Dollinger M., and Sowig P., 2013:
\emph{Mechanistic TK/TD-model simulating the effect of growth inhibitors on
Lemna populations}. Ecol Model 255, pp. 1-10. \doi{10.1016/j.ecolmodel.2013.01.017}
}
\seealso{
\link{Lemna-models}, \link{Macrophyte-models}, \link{Transferable}, \link{Scenarios}

Other Lemna models: 
\code{\link{Lemna-models}},
\code{\link{Lemna_Schmitt}()}

Other macrophyte models: 
\code{\link{Lemna_Schmitt}()},
\code{\link{Macrophyte-models}},
\code{\link{Myrio}()},
\code{\link{Myrio_log}()}
}
\concept{Lemna models}
\concept{macrophyte models}
