% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvfolds.R
\name{cvfolds}
\alias{cvfolds}
\title{Generate cross-validation folds}
\usage{
cvfolds(nfolds, datasize)
}
\arguments{
\item{nfolds}{The number of folds used in cross-validation.}

\item{datasize}{The sample size.}
}
\value{
A \code{list}. Each element contains the index vector of sample data included in this fold.
}
\description{
Randomly split the data indexes into \code{nfolds} folds.
}
\examples{
# Given sample size 20, generate 5 folds
set.seed(1212)
cvfolds(5, 20)
#[[1]]
# [1]  6 11 14 16
#[[2]]
# [1]  3  5 10 18
#[[3]]
# [1]  4  7  8 19
#[[4]]
# [1]  2  9 12 15
#[[5]]
# [1]  1 13 17 20

}
