% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_functions.R
\name{preprocess_functions}
\alias{preprocess_functions}
\title{Examples of preprocess_fn functions}
\usage{
preprocess_functions(name)
}
\arguments{
\item{name}{Name of preprocessing function
 as it appears in the following list:

 \tabular{rrr}{
  \strong{Name} \tab \strong{Description} \cr
  "standardize" \tab Centers and scales the numeric predictors\cr
  "range" \tab Normalizes the numeric predictors to the 0-1 range\cr
  "scale" \tab Scales the numeric predictors to have a standard deviation of one\cr
  "center" \tab Centers the numeric predictors to have a mean of zero\cr
  "warn" \tab Identity function that throws a warning and a message\cr
  }}
}
\value{
A function with the following form:

 \code{function(train_data, test_data, formula, hyperparameters) \{}

 \verb{    }\code{# Preprocess train_data and test_data}

 \verb{    }\code{# Return a list with the preprocessed datasets}

 \verb{    }\code{# and optionally a data frame with preprocessing parameters}

 \verb{    }\code{list(}

 \verb{        }\code{"train" = train_data,}

 \verb{        }\code{"test" = test_data,}

 \verb{        }\code{"parameters" = tidy_parameters}

 \verb{    }\code{)}

 \code{\}}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Examples of preprocess functions that can be used in
 \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}} and
 \code{\link[cvms:validate_fn]{validate_fn()}}.
 They can either be used directly or be starting points.

 The examples use \code{\link[recipes:recipe]{recipes}},
 but you can also use \code{caret::preProcess()} or
 similar functions.

 In these examples, the preprocessing will only affect the numeric predictors.

 You may prefer to hardcode a formula like \code{"y ~ ."} (where
 \code{y} is your dependent variable) as that will allow you to set
 \strong{`preprocess_one`} to \code{TRUE} in \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}}
 and \code{\link[cvms:validate_fn]{validate_fn()}} and save time.
}
\seealso{
Other example functions: 
\code{\link{model_functions}()},
\code{\link{predict_functions}()},
\code{\link{update_hyperparameters}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{example functions}
