% Generated by roxygen2 (4.0.1): do not edit by hand
\name{find_clusters}
\alias{find_clusters}
\title{Find clusters}
\usage{
find_clusters(A)
}
\arguments{
\item{A}{adjacency matrix}
}
\description{
\code{find_clusters} uses breadth-first search to identify the connected components of the corresponding
adjacency graph of the centroid differences vectors.
}
\examples{
## Clusterpaths for Mammal Dentition
data(mammals)
X <- as.matrix(mammals[,-1])
X <- t(scale(X,center=TRUE,scale=FALSE))
n <- ncol(X)

## Pick some weights and a sequence of regularization parameters.
k <- 5
phi <- 0.5
w <- kernel_weights(X,phi)
w <- knn_weights(w,k,n)
gamma <- seq(0.0,43, length.out=100)

## Perform clustering
nu <- AMA_step_size(w,n)
sol <- cvxclust_path_ama(X,w,gamma,nu=nu)

## Construct adjacency matrix
A <- create_adjacency(sol$V[[10]],w,n)
find_clusters(A)
}

