% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{cxhull}
\alias{cxhull}
\title{Convex hull}
\usage{
cxhull(points, triangulate = FALSE)
}
\arguments{
\item{points}{numeric matrix, one point per row}

\item{triangulate}{logical, whether to triangulate the convex hull}
}
\value{
A list providing a lot of information about the convex hull. See 
  the \strong{README} file for details.
}
\description{
Computes the convex hull of a set of points.
}
\examples{
points <- rbind(
 c(0.5,0.5,0.5),
 c(0,0,0),
 c(0,0,1),
 c(0,1,0),
 c(0,1,1),
 c(1,0,0),
 c(1,0,1),
 c(1,1,0),
 c(1,1,1)
)
cxhull(points)
}
