% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotConvexHull3d}
\alias{plotConvexHull3d}
\title{Plot triangulated 3d convex hull}
\usage{
plotConvexHull3d(
  hull,
  angleThreshold = NULL,
  edgesAsTubes = TRUE,
  verticesAsSpheres = TRUE,
  palette = NULL,
  bias = 1,
  interpolate = "linear",
  g = identity,
  facesColor = "navy",
  edgesColor = "gold",
  tubesRadius = 0.03,
  spheresRadius = 0.05,
  spheresColor = edgesColor
)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3d points and 
with the option \code{triangulate=TRUE}}

\item{angleThreshold}{a threshold angle in degrees, typically \code{179}, 
to get rid of edges between coplanar faces: edges whose corresponding 
dihedral angle is greater than this threshold are removed; \code{NULL} 
to use another method (see the Leonardo example)}

\item{edgesAsTubes}{Boolean, whether to draw the edges as tubes}

\item{verticesAsSpheres}{Boolean, whether to draw the vertices as spheres}

\item{palette}{a vector of colors to make a color gradient for the faces; 
if \code{NULL}, the colors of the faces are controlled by the 
\code{facesColor} argument}

\item{bias, interpolate}{if \code{palette} is not \code{NULL}, these arguments are 
passed to \code{\link[grDevices]{colorRamp}}}

\item{g}{a function defined on [0, 1] and taking its values in [0, 1]; it is 
composed with the function created by \code{\link[grDevices]{colorRamp}}, 
based on \code{palette}}

\item{facesColor}{the color(s) for the faces; this argument is ignored if 
the argument \code{palette} is not \code{NULL}; otherwise there are three 
possibilities for \code{facesColor}: 
a single color, a vector of colors with length the number of triangles, 
in which case one color is assigned per triangle, or a vector of colors 
with length the number of faces, after merging the triangles, in 
which case one color is assigned per face; use \code{\link{hullSummary}} 
to know the number of faces}

\item{edgesColor}{the color for the edges}

\item{tubesRadius}{the radius of the tubes when \code{edgesAsTubes=TRUE}}

\item{spheresRadius}{the radius of the spheres when 
\code{verticesAsSpheres=TRUE}}

\item{spheresColor}{the color of the spheres when 
\code{verticesAsSpheres=TRUE}}
}
\value{
No value.
}
\description{
Plot a triangulated 3d convex hull with \strong{rgl}.
}
\examples{
library(cxhull)
library(rgl)
cuboctahedron <- t(cuboctahedron3d()$vb[-4L, ])
hull <- cxhull(cuboctahedron, triangulate = TRUE)
# single color ####
open3d(windowRect = c(50, 50, 562, 562))
plotConvexHull3d(hull)
# gradient ####
open3d(windowRect = c(50, 50, 562, 562))
if(getRversion() < "4.1.0"){
  palette <- "Viridis"
}else{
  palette <- "Rocket"
}
plotConvexHull3d(hull, palette = hcl.colors(256, palette), bias = 0.5)

\donttest{
library(cxhull)
library(rgl)
# Leonardo da Vinci's 72-sided sphere ####
hull <- cxhull(daVinciSphere, triangulate = TRUE)
# there are some undesirable edges:
plotConvexHull3d(
  hull, tubesRadius = 0.07, spheresRadius = 0.1
)
# => use `angleThreshold` to get rid of these edges:
plotConvexHull3d(
  hull, angleThreshold = 179,
  tubesRadius = 0.07, spheresRadius = 0.1
)
}
}
