% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_vonmises.R
\docType{class}
\name{cyl_vonmises-class}
\alias{cyl_vonmises-class}
\title{An S4 Class of Bivariate vonMises Copulas}
\description{
This class contains circular-linear copulas that are based on the approach by
\insertCite{Johnson1978;textual}{cylcop} with a von Mises periodic function.
They are periodic in the circular dimension, u, but not symmetric with
respect to \eqn{u=0.5} i.e. there is no symmetry between positive and negative angles.
}
\section{Slots}{

\describe{
\item{\code{name}}{\link[base]{character} string holding the name of the copula.}

\item{\code{parameters}}{\link[base]{numeric} \link[base]{vector} holding the parameter values.}

\item{\code{param.names}}{\link[base]{character} \link[base]{vector} holding the
parameter names.}

\item{\code{param.lowbnd}}{\link[base]{numeric} \link[base]{vector} holding the lower
bounds of the parameters.}

\item{\code{param.upbnd}}{\link[base]{numeric} \link[base]{vector} holding the upper
bounds of the parameters.}

\item{\code{flip}}{\link[base]{logical} value indicating whether the copula should
be rotated 90 degrees to capture negative correlation.}
}}

\section{Objects from the Class}{

Objects are created by \code{\link{cyl_vonmises}()}.
}

\section{Extends}{

Class '\code{cyl_vonmises}' extends class '\code{\linkS4class{cyl_copula}}'.
}

\references{
\insertRef{Johnson1978}{cylcop}

\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
